from datetime import datetime
from typing import List, Optional

from pydantic import BaseModel, Field


class NyaiCharacterItem(BaseModel):
    id: int
    name: str
    author: str
    author_guest: bool
    created: datetime
    updated: datetime
    image_url: str
    content: str
    post_type: int
    tagline: str
    tags: List[str] = Field(default_factory=list)
    downloads: int
    comments: Optional[List] = Field(default_factory=list)
    description: str


def naime_api_to_char_item(data: dict) -> NyaiCharacterItem:
    downloads = 0
    for item in data['AdditionalDefinitions']:
        if 'DownloadCount' in item:
            downloads = item['DownloadCount']
    return NyaiCharacterItem(
        id=data['ID'],
        name=data['Title'],
        author=data['UserName'],
        author_guest=data['IsGuest'],
        created=data['Date'],
        updated=data['EditedDate'],
        image_url=data['ImageURL'],
        content=data['Content'],
        post_type=data['PostType'],
        tagline=data['ShortDescription'],
        tags=sorted([t['Name'] for t in data['Tags']]),
        downloads=downloads,
        comments=data['Comments'],
        description=data['Content'],
    )
