from concurrent.futures import ThreadPoolExecutor, as_completed

from scraper.log import root_logger
from scraper.nyai_me.process import nyai_process_card, nyai_process_author

_logger = root_logger.get_child('NYAI.RUNNERS')


def nyai_run_card_scrape(character_list, hashed_data_path, max_workers=10):
    new_items = 0
    updated_items = 0
    authors = set()

    with ThreadPoolExecutor(max_workers=max_workers) as executor:
        futures = {executor.submit(nyai_process_card, item, hashed_data_path) for item in character_list}
        for future in as_completed(futures):
            updated, is_new, author, name = future.result()
            if author is None and name is None:
                # Error has already been logged or it's chub.
                continue
            if author is not None:
                authors.add(author)
            author_name = ('!' if author[1] else '') + author[0]
            if is_new:
                _logger.info(f'NEW: {author_name} -- {name}')
                new_items += 1
            elif updated:
                _logger.info(f'Updated: {author_name} -- {name}')
                updated_items += 1
            else:
                _logger.info(f'{author_name} -- {name}')

    return new_items, updated_items, authors


def nyai_process_authors(authors, max_workers=10):
    new_authors = 0
    updated_authors = 0

    with ThreadPoolExecutor(max_workers=max_workers) as executor:
        futures = {executor.submit(nyai_process_author, author) for author in authors}
        for future in as_completed(futures):
            is_new, author = future.result()
            if is_new is None:
                continue
            if is_new:
                what = 'NEW'
                new_authors += 1
            else:
                what = 'UPDATED'
                updated_authors += 1
            _logger.info(('!' if author[1] else '') + author[0] + f': {what}')

    return new_authors, updated_authors
