from scraper.catbox.download import generic_download
from scraper.log import root_logger
from scraper.nyai_me.fetch import fetch_nyai_author
from scraper.nyai_me.insert_char import insert_nyai_character
from scraper.nyai_me.insert_user import insert_nyai_user

_logger = root_logger.get_child('NYAI.PROCESS')


def nyai_process_card(item, hashed_data_path):
    card_raw, card_parsed, img_bytes, _, err = generic_download(item.image_url, hashed_data_path, allow_non_catbox=True, specific_source='nai.me')
    if card_raw is None or card_parsed is None or img_bytes is None or err is not None:
        _logger.warning(f'{item.image_url} -- {err}')
        return None, None, None, None

    # if card_parsed.data.extensions.model_extra.get('chub'):
    #     is_new, is_updated, char = catbox_insert_chub_card(card_parsed, card_raw, img_bytes, hashed_data_path)
    #     if is_new:
    #         what = 'NEW'
    #     elif is_updated:
    #         what = 'UPDATED'
    #     else:
    #         what = 'FOUND'
    #     _logger.info(f'CHUB {what}: {char.node.id} -- {item.author} -- {item.name}')
    #     return is_new, None, None, None
    # else:
    updated, is_new = insert_nyai_character(card_parsed, item, img_bytes, card_raw, hashed_data_path)
    _logger.debug(f'Completed: {item.author} -- {item.name}')
    if err:
        _logger.warning(f'FAILED: "{err}"')
        return None, None, None, None
    return updated, is_new, (item.author, item.author_guest), item.name


def nyai_process_author(author: tuple):
    name, is_guest = author
    bio = ''
    discussions = []
    questions = []
    prompts = []
    requests = []
    meta = []
    if not is_guest:
        bio, discussions, questions, prompts, requests, meta, err = fetch_nyai_author(name)
        if err:
            _logger.warning(f'{name}: {err}')
            return None, None
    is_new = insert_nyai_user(name, is_guest, bio, discussions, questions, prompts, requests, meta)
    return is_new, author
