import json
from datetime import datetime, timezone

from scraper.database.connection import CursorFromConnectionFromPool


def insert_nyai_user(name: str, is_guest: bool, bio: str, discussions: list, questions: list, prompts: list, requests: list, meta: list):
    with CursorFromConnectionFromPool() as cursor:
        cursor.execute(
            'SELECT * FROM nyaime_user WHERE name = %s LIMIT 1',
            (name,)
        )
        if cursor.fetchone() is not None:
            cursor.execute(
                """
                UPDATE nyaime_user SET bio= %s, discussions = %s, questions = %s, prompts = %s, requests = %s, meta = %s, updated = %s WHERE name = %s;
                """,
                (json.dumps(bio), json.dumps(discussions), json.dumps(questions), json.dumps(prompts), json.dumps(requests), json.dumps(meta), datetime.now().astimezone(timezone.utc), name)
            )
            return False
        else:
            cursor.execute(
                """
                INSERT INTO nyaime_user (name, bio, discussions, questions, prompts, requests, meta, is_guest)
                VALUES (%s, %s, %s, %s, %s, %s, %s, %s);
                """,
                (name, json.dumps(bio), json.dumps(discussions), json.dumps(questions), json.dumps(prompts), json.dumps(requests), json.dumps(meta), is_guest)
            )
            return True
