import logging

import coloredlogs


def shut_up_loggers():
    logging.getLogger("requests").setLevel(logging.WARNING)
    logging.getLogger("urllib3").setLevel(logging.WARNING)
    logging.getLogger("PIL").setLevel(logging.WARNING)
    logging.getLogger('scrapy').setLevel(logging.WARNING)
    logging.getLogger('scrapy').propagate = False


class Logger:
    """
    A very hacky class to sync log levels between all modules in this project.
    This class allows us to grab a child logger in each module during import and then in our main()
    function we can set the global level even after all the modules have initialized their loggers.

    Example:
        log.root_logger.init(log_level)
        logger = log.root_logger.logger
        logger.info('hello!')
    """

    loggers = []
    _logger = None

    def __init__(self, name: str, level: int = logging.INFO):
        self._logger = self.__class__._logger
        self._logger = logging.getLogger(name)
        self._logger.setLevel(level)
        # handler = logging.StreamHandler()
        # formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
        # handler.setFormatter(formatter)
        # self._logger.addHandler(handler)
        self.__class__.loggers.append(self._logger)
        coloredlogs.install(logger=self._logger, level=level)
        self._log_level = level
        shut_up_loggers()

    @property
    def logger(self):
        return self._logger

    def root_level(self, level: int):
        self._log_level = level
        self._logger.setLevel(level)

    def get_child(self, name):
        child_logger = self._logger.getChild(name)
        self.__class__.loggers.append(child_logger)
        return child_logger

    def init(self, level):
        coloredlogs.install(logger=self._logger, level=level)
        self._log_level = level
        for logger in self.__class__.loggers:
            logger.setLevel(level)
            coloredlogs.install(logger=logger, level=self._log_level)


root_logger = Logger('MAIN')
