import io
from pathlib import Path

from scraper.database.hash import hash_bytestream
from scraper.globals import GLOBALS


def write_bytes_to_hashed_file(byte_stream: io.BytesIO):
    png_hash = hash_bytestream(byte_stream)
    png_dest_dir = GLOBALS.hashed_data_path / png_hash[0] / png_hash[1] / png_hash[2]
    png_dest_dir.mkdir(parents=True, exist_ok=True)
    png_dest = png_dest_dir / png_hash[3:]

    # I can't remember why I added this check, but it seems like the current scrapers
    # are all written around the assumption that this function will always overwrite the
    # file if it exists:
    # if not png_dest.exists():

    with open(png_dest, 'wb') as f:
        byte_stream.seek(0)
        f.write(byte_stream.read())

    return png_hash
