class HttpQueue:
    """
    A really backwards way to do things, but this allows me to define a
    global RequestQueue and update the object even after it's been
    imported by other modules. This is similar to the Logger class in log.py.
    This class is acts as a proxy for the RequestQueue object so I don't
    have to do things like queue.http_queue.http_queue.add() and instead do
    queue.http_queue.add().
    """

    # The RequestQueueManager object. Not typed due to circular import error.
    http_queue = None

    def add(self, *args, **kwargs):
        return self.http_queue.add(*args, **kwargs)

    def quit(self):
        if self.http_queue:
            self.http_queue.quit()


http_queue = HttpQueue()
