import argparse
import subprocess

import dateparser

"""
Various one-off functions support other operations.
"""


def du(p):
    return subprocess.check_output(['du', '-sh', p]).split()[0].decode('utf-8')


def is_string_empty(s: str):
    if isinstance(s, str):
        return len(s.strip()) == 0
    else:
        raise ValueError("Input should be a string")


def valid_date(s):
    try:
        return dateparser.parse(s, settings={'TIMEZONE': 'UTC', 'RETURN_AS_TIMEZONE_AWARE': True})
    except ValueError:
        msg = "Not a valid date: '{0}'.".format(s)
        raise argparse.ArgumentTypeError(msg)


def is_service_running(service_name: str, user: bool = False):
    try:
        output = subprocess.check_output(f"systemctl {'--user' if user else ''} is-active --quiet " + service_name, shell=True)
        return True
    except subprocess.CalledProcessError:
        return False
    except Exception as e:
        print(f"An error occurred while checking the service status: {e}")
        return False
