from pathlib import Path
from typing import Tuple, Dict


class Globals:
    _request_timeout_set = False
    _request_timeout = (30, 30)

    _headers_set = False
    _headers = {
        'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'accept-language': 'en-US,en;q=0.9',
        'priority': 'u=0, i',
        'sec-ch-ua': '"Chromium";v="124", "Google Chrome";v="124", "Not-A.Brand";v="99"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"Windows"',
        'sec-fetch-dest': 'document',
        'sec-fetch-mode': 'navigate',
        'sec-fetch-site': 'cross-site',
        'sec-fetch-user': '?1',
        'upgrade-insecure-requests': '1',
        'user-agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36',
    }

    enable_logging = False
    debug_logging = False
    hide_404s = False
    proxies = []
    log_http_requests = False
    log_requests_per_sec = False
    _hashed_data_path = None

    @property
    def request_timeout(self) -> Tuple[int, int]:
        return self._request_timeout

    @request_timeout.setter
    def request_timeout(self, timeout: Tuple[int, int]) -> None:
        """
        Set the default timeout for all HTTP requests.

        :param timeout: `Tuple[int, int]`. (connect, read).
        """
        if self._request_timeout_set:
            raise AttributeError("This attribute can only be set once.")
        if not isinstance(timeout, tuple) and len(timeout) != 2:
            raise ValueError("default_request_timeout must have two values: connect timeout and read timeout")
        self._request_timeout = timeout[0], timeout[1]
        self._request_timeout_set = True

    @property
    def request_timeout_longer(self) -> Tuple[int, int]:
        """
        A longer timeout that gives the server more time to finish the data transfer.

        `longer connect timeout = connect timeout * 2`

        `longer read timeout = max(120, read timeout * 2)`

        :return: `Tuple[int, int]`. (connect, read).
        """
        connect = self._request_timeout[1] * 2
        read = max(120, self._request_timeout[1] * 2)
        return connect, read

    @property
    def headers(self) -> Dict[str, str]:
        """
        The default request headers for all HTTP requests.
        :return: `Dict[str, str]`
        """
        return self._headers

    @headers.setter
    def headers(self, headers: Dict[str, str]):
        """
        Set the default request headers for all HTTP requests. Make sure your dict is only strings.
        :param headers: `dict`
        """
        if self._headers_set:
            raise AttributeError("This attribute can only be set once.")
        if not isinstance(headers, dict):
            raise ValueError("Must be a dictionary")
        self._headers = headers

    @property
    def card_image_max_dimensions(self):
        return 1000, 1000

    @property
    def chub_user_image_max_dimensions(self):
        return 284, 284

    @property
    def hashed_data_path(self) -> Path:
        return self._hashed_data_path

    @hashed_data_path.setter
    def hashed_data_path(self, p: Path) -> None:
        if self._hashed_data_path:
            raise AttributeError("This attribute can only be set once.")
        self._hashed_data_path = Path(p).expanduser().resolve().absolute()


GLOBALS = Globals()
