import concurrent.futures
import os
from pathlib import Path
from typing import Union

import humanize


def get_dir_size(path: Union[str, Path], max_workers: int = 50, human: bool = False):
    total = 0
    with concurrent.futures.ThreadPoolExecutor(max_workers=max_workers) as executor:
        futures = {executor.submit(get_entry_size, entry): entry for entry in os.scandir(path)}
        for future in concurrent.futures.as_completed(futures):
            total += future.result()
    return humanize.naturalsize(total) if human else total


def get_entry_size(entry: os.DirEntry):
    if entry.is_file():
        return entry.stat().st_size
    elif entry.is_dir():
        return get_dir_size(entry.path)
    return 0
