import hashlib
import io


def hash_bytestream(byte_stream: io.BytesIO):
    byte_stream.seek(0)
    file_hash = hashlib.md5()
    for chunk in iter(lambda: byte_stream.read(4096), b""):
        file_hash.update(chunk)
    return file_hash.hexdigest()
