from PIL import ImageOps, Image
from PIL.Image import Image as ImageType


def strip_exif(img: ImageType):
    """
    Strip EXIF data from an image while preserving the visual content.
    """
    # Apply EXIF orientation
    original = ImageOps.exif_transpose(img)

    # Create new image with same mode and size
    stripped = Image.new(original.mode, original.size)

    # For RGBA images, we need to handle the data carefully
    if original.mode == 'RGBA':
        # This ensures the data is properly formatted
        stripped.paste(original, (0, 0))
    else:
        # For other modes, putdata should work fine
        stripped.putdata(list(original.getdata()))

    # Copy palette if it exists
    if hasattr(original, 'palette') and original.palette:
        stripped.putpalette(original.palette)

    return stripped
