from pathlib import Path
from typing import List

from pydantic import BaseModel


class DatabaseConfig(BaseModel):
    database: str
    user: str
    password: str
    host: str
    port: int


class SiteConfig(BaseModel):
    http_workers: int
    download_threads: int


class ChubConfig(SiteConfig):
    hide_404s: bool


class CatboxConfig(BaseModel):
    http_workers: int
    rentry_threads: int
    desu_threads: int
    catbox_threads: int


class ProxyStatsConfig(BaseModel):
    http_workers: int


class CharacterTavernConfig(BaseModel):
    http_workers: int

class ConfigModel(BaseModel):
    proxies: List
    database: DatabaseConfig
    request_connect_timeout: int
    request_read_timeout: int
    warn_workers_ratelimit: int
    log_http_requests: bool
    log_requests_per_sec: bool
    hashed_data_path: Path
    chub: ChubConfig
    catbox: CatboxConfig
    webring: SiteConfig
    risuai: SiteConfig
    nyai_me: SiteConfig
    proxy_tracker: ProxyStatsConfig
    character_tavern: CharacterTavernConfig
