#!/usr/bin/env python3
import signal

import yaml

import scraper
from scraper import RequestQueueManager
from scraper.config.models import ConfigModel
from scraper.globals import GLOBALS
from scraper.log import root_logger
from scraper.paths import resolve_path

_logger = root_logger.get_child('CFG')


def load_cfg(args):
    cfg_data = yaml.load(resolve_path(args.config).read_text(), Loader=yaml.FullLoader)
    cfg = ConfigModel(**cfg_data)

    _logger.info(f'Run time limit: {args.run_time_limit} seconds.')
    signal.alarm(args.run_time_limit)

    GLOBALS.log_http_requests = cfg.log_http_requests or args.log_requests
    GLOBALS.request_timeout = (cfg.request_connect_timeout, cfg.request_read_timeout)
    GLOBALS.hashed_data_path = cfg.hashed_data_path

    GLOBALS.proxies = cfg.proxies
    scraper.init_proxy_pool()
    scraper.http_queue.http_queue = RequestQueueManager(
        num_workers_per_proxy=cfg.chub.http_workers
    )

    return cfg
