from pydantic import BaseModel, Field


class ChubUserNode(BaseModel):
    id: int
    name: str
    username: str
    agnai_id: str = ""
    avatar_url: str = ""
    bio: str = ""
    discord: str = ""
    first_name: str = ""
    last_name: str = ""
    models: dict = Field(default_factory=dict)
    n_followees: int = 0
    n_followers: int = 0
    projects: dict = Field(default_factory=dict)
    public_email: str = ""
    twitter: str = ""
    website_url: str = ""


class ChubUser:
    def __init__(self, user: ChubUserNode, png_bytes: bytes):
        assert isinstance(user, ChubUserNode)
        self._user = user
        self._png_bytes = png_bytes

    @property
    def png_bytes(self):
        return self._png_bytes

    @property
    def user(self):
        return self._user
