from typing import Dict, Any

from pydantic import Field

from scraper.card_types.ccv2.lorebook import LorebookV2
from scraper.chub.common_scrape import normalize_for_chub
from scraper.chub.types.chats_ratings import ChubRatings
from scraper.chub.types.node import clean_chub_node, ChubBaseNode


class ChubLoreNode(ChubBaseNode):
    definition: Dict[str, Any] = Field(default_factory=dict)


class ChubLorebook:
    def __init__(self, node: ChubLoreNode, lorebook: LorebookV2, png_bytes: bytes, ratings: ChubRatings = None):
        self._node = node
        self._lorebook = normalize_for_chub(lorebook, node.id, node.fullPath)
        self._png_bytes = png_bytes

        if ratings:
            self._ratings = ratings
        else:
            self._ratings = ChubRatings()

    @property
    def png_bytes(self) -> bytes:
        return self._png_bytes

    @property
    def node(self) -> ChubLoreNode:
        return self._node

    @property
    def lorebook(self) -> LorebookV2:
        return self._lorebook

    @property
    def ratings(self) -> ChubRatings:
        return self._ratings


def normalize_chub_lore_node(node_data: dict) -> ChubLoreNode:
    node_data = clean_chub_node(node_data)
    return ChubLoreNode(**node_data)
