import random

from scraper import http_queue
from scraper.chub.chub import CHUB_TYPE_STR
from scraper.chub.types.chub_lorebook import ChubLoreNode
from scraper.log import root_logger
from scraper.card_types.ccv2.lorebook import normalize_lorebook

logger = root_logger.get_child('CHUB.LORE.SCRAPE')


def scrape_chub_lore_def(node: ChubLoreNode):
    """
    Fetch the lorebook definition.
    """
    raw_url = f'https://api.chub.ai/api/v4/projects/{node.id}/repository/files/raw%252Fsillytavern_raw.json/raw?ref=main&response_type=blob&nocache=0.{random.randrange(1, 10 ** 16):03}'
    r = http_queue.add(raw_url)
    if r is None:
        return None, None, f'no response -> {raw_url}'
    if r.status_code == 404 or r.status_code == 500:
        # 404 errors are usually fine because it means the card hasn't finished processing yet
        # or was deleted between the time we scraped the node list and now.
        return None, None, f'Code: {r.status_code} -> {raw_url}'
    elif r.status_code != 200:
        return None, None, f'Code: {r.status_code} -> {raw_url}'

    raw_data = r.json()
    lorebook_obj = normalize_lorebook(raw_data, CHUB_TYPE_STR)
    return lorebook_obj, r.text, None
