import random
from typing import Union

from scraper.chub.types.chub_character import ChubCharNode
from scraper.chub.types.chub_lorebook import ChubLoreNode
from scraper.download import fetch_json


def get_chub_node_def(node: Union[ChubCharNode, ChubLoreNode], api_raw_file: str):
    """
    Fetch the definition from the chub API.
    """
    raw_url = f'https://gateway.chub.ai/api/v4/projects/{node.id}/repository/files/{api_raw_file}/raw?ref=main&response_type=blob&nocache=0.{random.randrange(1, 10 ** 16):03}'
    return fetch_json(raw_url)
