import random
import time
import traceback
from typing import Union

from scraper import http_queue
from scraper.card_types.ccv2.character import TavernCardv2
from scraper.card_types.ccv2.lorebook import LorebookV2


def scrape_chub_ratings(identifier: id):
    url = f'https://gateway.chub.ai/api/project/{identifier}/ratings?nocache=0.{random.randrange(1, 10 ** 16):03}'
    last_traceback = None
    last_status_code = None
    for i in range(3):
        r = http_queue.add(url)
        if r is None:
            return None, 'no response', None
        last_status_code = r.status_code
        if r.status_code == 404 or r.status_code == 500:
            return None, None, r.status_code
        elif r.status_code != 200:
            time.sleep(5)
            continue
        try:
            return r.json(), None, None
        except:
            last_traceback = traceback.format_exc()
            time.sleep(5)
            continue
    return None, last_traceback, last_status_code


def fetch_chub_api_json(path: str):
    url = 'https://api.chub.ai/' + path.lstrip('/')
    last_traceback = None
    last_status_code = None
    for i in range(3):
        r = http_queue.add(url)
        if r is None:
            return None, 'no response', None
        last_status_code = r.status_code
        if r.status_code == 404 or r.status_code == 500:
            return None, None, r.status_code
        elif r.status_code != 200:
            time.sleep(5)
            continue
        try:
            return r.json(), None, None
        except:
            last_traceback = traceback.format_exc()
            time.sleep(5)
            continue
    return None, last_traceback, last_status_code


def normalize_for_chub(card: Union[TavernCardv2, LorebookV2], chub_id: int, chub_full_path: str):
    data = {
        'id': chub_id,
        'full_path': chub_full_path,
        'expressions': None,
        'related_lorebooks': []
    }
    if isinstance(card, TavernCardv2):
        if not card.data.extensions.model_dump().get('chub'):
            card.data.extensions.chub = data
    elif isinstance(card, LorebookV2):
        if not card.extensions.model_dump().get('chub'):
            card.extensions.chub = data
    else:
        raise Exception
    return card
