import random
import time
import traceback

from scraper import http_queue
from scraper.chub.types.chub_character import ChubCharExpressions, ChubCharNode
from scraper.log import root_logger

logger = root_logger.get_child('CHUB.CHAR.SCRAPE')


def scrape_expressions(node: ChubCharNode):
    url = f'https://api.chub.ai/api/v4/projects/{node.id}/repository/files/expressions.json/raw?ref=main&response_type=blob?nocache=0.{random.randrange(1, 10 ** 16):03}'
    last_traceback = None
    last_status_code = None
    for i in range(3):
        r = http_queue.add(url)
        if r is None:
            return None, 'no response', None
        last_status_code = r.status_code
        if r.status_code == 404 or r.status_code == 500:
            return ChubCharExpressions()
        elif r.status_code != 200:
            time.sleep(5)
            continue
        try:
            data = r.json()
        except:
            last_traceback = traceback.format_exc()
            time.sleep(5)
            continue
        return ChubCharExpressions(**data), None, None
    return None, last_traceback, last_status_code
