from typing import List, Optional

from pydantic import BaseModel


class CharTavernNode(BaseModel):
    name: str
    inChatName: Optional[str] = None
    path: str
    tagline: str
    pageDescription: Optional[str] = None
    author: str
    isNSFW: bool
    contentWarnings: List[str]
    characterDefinition: str
    characterPersonality: Optional[str] = None
    characterScenario: Optional[str] = None
    characterFirstMessage: str
    characterExampleMessages: Optional[str] = None
    characterPostHistoryPrompt: Optional[str] = None
    alternativeFirstMessage: List[str]
    tags: List[str]
    views: int
    downloads: int
    messages: int
    createdAt: int
    lastUpdateAt: int
    likes: int
