import re
from datetime import datetime, timezone
from typing import Union, List


def _extract_review_key(key: str, review_raw: str) -> Union[str, int, float, bool, None]:
    m = re.search(key + r':(.*?)[,}]', review_raw)
    if m:
        return m.group(1).strip('"')
    return None


def parse_char_tavern_reviews(page_html: str) -> List[dict]:
    # Figure out where the reviews array ends.
    x = page_html.split('reviews:')
    assert len(x) == 2
    y = x[1]
    i = 0
    for z in y:
        i += 1
        if z == ']':
            break
    reviews_str = y[:i]

    reviews_raw = re.findall(r'(\{[^{}]*\}*)', reviews_str)
    reviews = []
    for item in reviews_raw:
        review_id = _extract_review_key('id', item)
        review_date_obj = _extract_review_key('createdAt', item)
        review_ts = datetime.fromtimestamp(int(re.match(r'new Date\((\d*)\)', review_date_obj).group(1)) // 1000).astimezone(timezone.utc).isoformat()
        review_comment = _extract_review_key('comment', item)
        review_username = _extract_review_key('username', item)
        review_displayname = _extract_review_key('displayname', item)
        reviews.append({
            'id': review_id,
            'createdAt': review_ts,
            'comment': review_comment,
            'username': review_username,
            'displayname': review_displayname
        })
    return reviews
