import os
import subprocess
import sys

from scraper import http_queue
from scraper.log import root_logger

_logger = root_logger.get_child('CHAR-TAVERN.EXECUTE-AUTH-HEADER')


def get_character_tavern_auth():
    """
    Get the authorization header from character-tavern.com
    Returns the Bearer token as a string
    """
    script_dir = os.path.dirname(os.path.realpath(__file__))
    _logger.debug(f"Executing script: \"{sys.executable} {os.path.join(script_dir, 'get_auth_header.py')}\"")
    try:
        result = subprocess.run(
            [sys.executable, os.path.join(script_dir, 'get_auth_header.py')],
            capture_output=True,
            text=True,
            check=True
        )
        auth_header = result.stdout.strip()
        if not auth_header.startswith('Bearer'):
            _logger.error(f"Failed to get auth header: {auth_header}")
            return None
        return auth_header
    except subprocess.CalledProcessError as e:
        _logger.error(f"Error getting auth header: {e.stderr.strip()}")
        return None
    except Exception as e:
        _logger.error(f"Unexpected error: {e}")
        return None


def test_character_tavern_auth(auth_header: str):
    r = http_queue.add(
        'https://search.character-tavern.com/indexes/characters/search', method='POST',
        headers={
            'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64; rv:140.0) Gecko/20100101 Firefox/140.0',
            'Accept-Language': 'en-US,en;q=0.5',
            'Referer': 'https://character-tavern.com/',
            'authorization': auth_header,
            'content-type': 'application/json',
            'x-meilisearch-client': 'Meilisearch JavaScript (v0.52.0)',
            'Origin': 'https://character-tavern.com',
            'DNT': '1',
            'Sec-GPC': '1',
            'Connection': 'keep-alive',
            'Sec-Fetch-Dest': 'empty',
            'Sec-Fetch-Mode': 'cors',
            'Sec-Fetch-Site': 'same-site',
            'Priority': 'u=4',
            'Pragma': 'no-cache',
            'Cache-Control': 'no-cache',
        },
        json_data={
            'q': 'girl',
            'hitsPerPage': 49,
            'sort': [
                'likes:desc',
                'messages:desc',
                'downloads:desc',
                'createdAt:desc',
            ],
            'filter': [
                '(contentWarnings IS EMPTY OR contentWarnings NOT IN [])',
            ],
            'page': 1,
        }
    )
    return r.status_code
