from io import BytesIO

from PIL import Image

from scraper.download import download_file
from scraper.globals import GLOBALS
from scraper.log import root_logger

_logger = root_logger.get_child('CHAR-TAVERN.DOWNLOAD')


def char_tavern_download(path: str):
    url = f'https://cards.character-tavern.com/{path}.png'
    png_bytes = download_file(url, ignore_404=True, timeout=GLOBALS.request_timeout_longer)
    if not png_bytes:
        # Some sort of server error (404, etc).
        return None
    try:
        img = Image.open(BytesIO(png_bytes))
        img.verify()
        return png_bytes
    except Exception as e:
        _logger.error(f'Downloaded image failed to load: {path} -- {url} -- {e}')
        return None
