import functools
from concurrent.futures import ThreadPoolExecutor, as_completed
from pathlib import Path

from scraper.catbox.download import catbox_download_and_import_card, CatboxDownloadType
from scraper.log import root_logger

_logger = root_logger.get_child('CATBOX.PROCESS')


def catbox_download_pngs(threads, hashed_data_path: Path, links, extra_metadata: dict = None, allow_non_catbox: bool = False, specific_source: str = None):
    new_items = 0
    new_chub = 0
    with ThreadPoolExecutor(max_workers=threads) as executor:
        futures = {executor.submit(functools.partial(catbox_download_and_import_card, hashed_data_path, link, specific_source, allow_non_catbox, extra_metadata), ) for link in links}
        for future in as_completed(futures):
            try:
                card_type, chub_card, is_new, is_updated, url, err = future.result()
            except ValueError as e:
                _logger.error(f'Failed to process image: {e}')
                continue

            url = url.replace(' ', '%20')
            if err and err != 'Invalid PNG metadata':
                _logger.error(f'{url} -- {err}')
            else:
                chub_str = ''
                if CatboxDownloadType.CHUB and chub_card:
                    chub_str = f' -- CHUB {chub_card.node.fullPath}'
                    new_chub += 1
                _logger.debug(f'Completed: {url}{chub_str}')
                if is_new:
                    _logger.info(f'NEW: {url}{chub_str}')
                    new_items += 1
    return new_items, new_chub
