from typing import Union

import psycopg2

from scraper.database.connection import CursorFromConnectionFromPool


def load_stored_rentry_links():
    with CursorFromConnectionFromPool() as cursor:
        cursor.execute('SELECT url FROM stored_rentry_links')
        return {x[0] for x in cursor.fetchall()}


def insert_rentry_links(rentry_links: Union[list, set]):
    for link in rentry_links:
        if link == 'https://rentry.org/':
            continue
        assert link.startswith('https://rentry.org/')
        with CursorFromConnectionFromPool() as cursor:
            try:
                cursor.execute('INSERT INTO stored_rentry_links (url) VALUES (%s)', (link,))
            except psycopg2.errors.UniqueViolation as e:
                if 'duplicate key' in str(e).lower():
                    # duplicate entry, do nothing
                    pass
                else:
                    # an unexpected error occurred
                    raise
