import re
from datetime import datetime
from typing import Union

from dateparser import parse

from scraper.card_types.item_extensions import parse_date_field


def st_timestamp_to_datetime(timestamp: str) -> datetime | None:
    try:
        match = re.match(r'(\d{4}-\d{1,2}-\d{1,2}) @(\d{2}h \d{2}m \d{2}s) (\d{1,3}ms)', timestamp)
        if match:
            # Extract date, time and milliseconds
            date_str = match.group(1)
            time_str = match.group(2).replace('h ', ':').replace('m ', ':').replace('s', '')
            ms_str = match.group(3).replace('ms', '')

            # Combine date and time into one string
            datetime_str = f'{date_str} {time_str}'

            # Parse date and time
            dt = datetime.strptime(datetime_str, '%Y-%m-%d %H:%M:%S')

            # Parse milliseconds and convert to seconds
            ms = int(ms_str) / 1000.0

            # Add milliseconds to datetime
            dt = dt.replace(microsecond=int(ms * 1e6))

            return dt
        else:
            return None
    except:
        return None


def parse_st_create_date_timestamp(v: Union[str, None]) -> datetime:
    """
    Convert the timestamp string in `create_date` to a datetime object.
    :param v:
    :return:
    """
    if v is None:
        return datetime.fromtimestamp(0)
    elif isinstance(v, datetime):
        return v
    elif isinstance(v, (int, float)):
        # Edge case where it was a Unix timestamp.
        return parse_date_field(v)
    p = st_timestamp_to_datetime(v)
    if p is not None:
        return p
    # If a match hasn't been made, assume that we are reprocessing our own data and parse the ISO timestamp.
    return parse(v)
