from scraper.card_types.ccv2.character import TavernCardv2
from scraper.card_types.ccv2.infer import infer_specv2_card
from scraper.card_types.ccv3.character import CharacterCardV3
from scraper.card_types.ccv3.infer import infer_specv3_card


def infer_anyspec_card(raw_card: dict, source: str, author: str = None) -> CharacterCardV3 | TavernCardv2:
    if not author:
        author = raw_card.get('data', {}).get('author')

    if raw_card.get('spec_version') == '3.0':
        return infer_specv3_card(raw_card, source)
    elif raw_card.get('spec_version') == '2.0' or raw_card.get('spec_version') is None:  # v1 and v2
        return infer_specv2_card(raw_card, source, author)
    else:
        raise Exception(f'Invalid spec version: {raw_card.get("spec_version")}')
