import re
from typing import Union

from scraper.card_types.ccv2.character import TavernCardv2
from scraper.card_types.ccv2.funcs import count_v2char_tokens
from scraper.card_types.ccv3.character import CharacterCardV3
from scraper.card_types.ccv3.funcs import count_v3char_tokens


def test_card_name(name: str):
    if name == '':
        return False
    if re.match(r'^(\s|[⠀])*$', name):  # blank space is the "U+2800 Braille Pattern Blank Unicode Character"
        return False
    return True


def count_char_tokens(card: Union[CharacterCardV3, TavernCardv2]):
    if isinstance(card, CharacterCardV3):
        return count_v3char_tokens(card)
    else:
        return count_v2char_tokens(card)
