import copy

from scraper.card_types.ccv2.character import TavernCardv2
from scraper.card_types.ccv2.infer import infer_specv2_card
from scraper.card_types.ccv3.character import CharacterCardV3, CharacterCardV3Data
from scraper.card_types.funcs import test_card_name
from scraper.card_types.item_extensions import CharArchiveExtension
from scraper.card_types.st_timestamp import parse_st_create_date_timestamp


def normalize_cardv3(raw_card: dict, source: str, specific_author: str = None, specific_name: str = None):
    full_card = copy.deepcopy(raw_card)
    del raw_card
    if not test_card_name(full_card['data']['name']):
        raise ValueError('Character name is empty')

    if specific_author:
        full_card['data']['creator'] = specific_author
    if specific_name:
        full_card['data']['name'] = specific_name

    # Create the char archive extension while preserving existing data char archive extension data.
    if not full_card['data'].get('extensions'):
        full_card['data']['extensions'] = {}
    if not full_card['data']['extensions'].get('char_archive'):
        full_card['data']['extensions']['char_archive'] = {}
    full_card['data']['extensions']['char_archive']['source'] = source
    full_card['data']['extensions']['char_archive']['created'] = full_card['data'].get('creation_date')
    full_card['data']['extensions']['char_archive'] = CharArchiveExtension(**full_card['data']['extensions']['char_archive']).model_dump()

    if not full_card['data'].get('creation_date') and full_card.get('create_date'):
        full_card['data']['creation_date'] = int(parse_st_create_date_timestamp(full_card['create_date']).timestamp())

    # Fix some old errors.
    # if isinstance(full_card['data']['creation_date'], str):
    #     full_card['data']['creation_date'] = int(parse(full_card['data']['creation_date']).timestamp())

    # TODO: not needed?
    # if definition.get('character_book'):
    #     definition['character_book']['entries'] = normalize_lorebook_entries(definition['character_book']['entries'])

    # Character Tavern cards might be missing the `scenario` key. If so, copy the description to it.
    if not full_card['data'].get('scenario') and full_card['data'].get('description'):
        full_card['data']['scenario'] = full_card['data']['description']

    card = CharacterCardV3(**full_card)
    del full_card

    if card.data.character_book:
        del card.data.character_book.extensions.char_archive

    return card


def convert_spec2_to_spec3(card_v2: TavernCardv2):
    return CharacterCardV3(data=CharacterCardV3Data(**copy.deepcopy(card_v2).data.model_dump()))


def infer_specv3_card(raw_card: dict, source: str, specific_author: str = None, specific_name: str = None):
    full_card = raw_card.copy()
    if 'data' in list(full_card.keys()) and raw_card.get('spec') == 'chara_card_v3':
        return normalize_cardv3(raw_card, source, specific_author=specific_name, specific_name=specific_name)
    else:
        return normalize_cardv3(convert_spec2_to_spec3(infer_specv2_card(raw_card, specific_author, source)).model_dump(), source, specific_author=specific_name, specific_name=specific_name)
