import tiktoken

from scraper.card_types.ccv3.character import CharacterCardV3
from scraper.sort import sort_dict


def count_v3char_tokens(card: CharacterCardV3):
    # Some of these fields are None by default.
    text_stuff = (
            (card.data.scenario if card.data.scenario else '') +
            (card.data.first_mes if card.data.first_mes else '') +
            (card.data.mes_example if card.data.mes_example else '') +
            (card.data.personality if card.data.personality else '') +
            (card.data.description if card.data.description else '')
    )
    return len(tiktoken.get_encoding("cl100k_base").encode(text_stuff, disallowed_special=()))


def normalize_v3card_for_comparison(card: CharacterCardV3):
    d = card.model_dump()
    del d['data']['extensions']
    return sort_dict(d)
