from typing import Optional, List, Dict

from pydantic import BaseModel, Field, field_validator

from scraper.card_types.ccv3.lorebook import CharacterCardV3Lorebook
from scraper.card_types.item_extensions import ItemExtensions


class CharacterCardV3Asset(BaseModel):
    type: str
    uri: str
    name: str
    ext: str


class CharacterCardV3Data(BaseModel):
    name: str
    first_mes: str
    scenario: str
    extensions: Optional[ItemExtensions] = Field(default_factory=ItemExtensions)
    alternate_greetings: List[str] = Field(default_factory=list)
    group_only_greetings: List[str] = Field(default_factory=list)
    description: Optional[str] = None
    character_version: Optional[str] = None
    system_prompt: Optional[str] = None
    mes_example: Optional[str] = None
    personality: Optional[str] = None
    post_history_instructions: Optional[str] = None
    creator: Optional[str] = None
    tags: Optional[List[str]] = Field(default_factory=list)
    creator_notes: Optional[str] = None
    character_book: Optional['CharacterCardV3Lorebook'] = None
    assets: Optional[List['CharacterCardV3Asset']] = None
    nickname: Optional[str] = None
    creator_notes_multilingual: Optional[Dict[str, str]] = None
    source: Optional[List[str]] = None
    creation_date: Optional[int] = 0
    modification_date: Optional[int] = 0

    class Config:
        validate_assignment = True

    @field_validator('creation_date', 'modification_date', mode='before')
    @classmethod
    def parse_date(cls, v, field):
        if v is None:
            return 0
        if isinstance(v, (int, float)):
            return int(v)
        raise ValueError(f"{field.field_name} must be an int or float")


class CharacterCardV3(BaseModel):
    spec: str = 'chara_card_v3'
    spec_version: str = '3.0'
    data: CharacterCardV3Data
