import tiktoken

from scraper.card_types.ccv2.character import TavernCardv2


def count_v2char_tokens(card: TavernCardv2):
    text_stuff = card.data.scenario + card.data.first_mes + card.data.mes_example + card.data.example_dialogue + card.data.description
    return len(tiktoken.get_encoding("cl100k_base").encode(text_stuff, disallowed_special=()))


def normalize_v2card_for_comparison(card: dict):
    try:
        del card['creatorcomment']
    except KeyError:
        pass
    try:
        del card['create_date']
    except KeyError:
        pass
    try:
        del card['data']['extensions']
    except KeyError:
        pass
    try:
        del card['data']['creator']
    except KeyError:
        pass
    try:
        del card['data']['tags']
    except KeyError:
        pass
    try:
        del card['data']['creator_notes']
    except KeyError:
        pass
    try:
        del card['data']['character_version']
    except KeyError:
        pass
    return card
