import json
from datetime import timezone, datetime

from scraper.log import root_logger
from .database import MySQLConnection
from .parse import parse_usage, fix_all_questions

logger = root_logger.get_child('PROXY_STATS.OPERATIONS')

mysql_conn = MySQLConnection('172.0.3.109', 'proxy_stats', 'bp9xrimxpDspfGhp', 'proxy_stats')


def prepare_data(proxy_json: dict) -> dict:
    """Prepare the data for insertion."""
    proxy_json['uptime'] = float(proxy_json['uptime'])
    proxy_json['timestamp'] = int(datetime.now(tz=timezone.utc).timestamp())

    if proxy_json.get('tookens'):
        if isinstance(proxy_json['tookens'], str):
            proxy_json['tookens'] = parse_usage(proxy_json['tookens'])
        elif isinstance(proxy_json['tookens'], (int, float)):
            # We are assuming a single value is token usage.
            proxy_json['tookens'] = {'tokens': proxy_json['tookens'], 'cost': float(-1)}
    else:
        proxy_json['tookens'] = {'tokens': float(-1), 'cost': float(-1)}

    # Catch any future Elastic errors
    assert isinstance(proxy_json['tookens'], dict)

    proxy_json = convert_all_usage(proxy_json)  # need to convert this so Elastic doesn't get confused.
    proxy_json = reverse_all_wait_str(proxy_json)

    # TODO: remove this
    proxy_json = fix_all_questions(proxy_json)

    proxy_json['json'] = json.dumps(proxy_json)
    return proxy_json


def reverse_proxy_wait(wait_str: str):
    """
    Reversed from oai-reverse-proxy
    https://gitgud.io/khanon/oai-reverse-proxy/-/blob/main/src/info-page.ts?ref_type=heads#L569
    :param wait_str:
    :return:
    """
    assert isinstance(wait_str, str)
    if wait_str == "no wait":
        return 0

    time_parts = wait_str.split(", ")
    total_seconds = 0
    for part in time_parts:
        if "min" in part:
            value, _ = part.split("min")
            total_seconds += int(value) * 60
        elif 'sec' in part:
            value, _ = part.split("sec")
            total_seconds += int(value)
    return total_seconds


def reverse_all_wait_str(json_data: dict):
    assert isinstance(json_data, dict)
    for k, v in json_data.items():
        if isinstance(v, str):
            v = v.lower()
            if 'min, ' in v or v.endswith('sec') or v == 'no wait':
                json_data[k] = reverse_proxy_wait(v)
        elif isinstance(v, dict):
            json_data[k] = reverse_all_wait_str(v)
        # elif isinstance(v, (list, tuple)):
        #     for i, vv in enumerate(v):
        #         if isinstance(vv, str):
        #             print(v)
        #             json_data[k][i] = reverse_proxy_wait(vv)
    return json_data


def convert_all_usage(json_data: dict):
    for k, v in json_data.items():
        if isinstance(v, str):
            if '$' in v or 'tokens' in v:
                json_data[k] = parse_usage(v)
        elif isinstance(v, dict):
            json_data[k] = convert_all_usage(v)
    return json_data
