import time


def validate_unix_timestamp(timestamp):
    # Check if timestamp is an integer
    try:
        timestamp = int(timestamp)
    except ValueError:
        return False
    except TypeError:
        return False

    # if not isinstance(timestamp, int):
    #     return False
    # Check if timestamp is positive
    if timestamp < 0:
        return False
    # Check if timestamp corresponds to a valid date
    try:
        time.gmtime(timestamp)
    except ValueError:
        return False
    # Check if timestamp is not in the future
    # if timestamp > int(time.time()):
    #     return False
    return True


def convert_dict_values_to_int(dictionary: dict):
    for key in dictionary:
        if check_int(dictionary[key]):
            dictionary[key] = int(dictionary[key])
    return dictionary


def convert_dict_values_to_bool(dictionary: dict):
    for key in dictionary:
        if isinstance(dictionary[key], str):
            if dictionary[key].lower() == 'false':
                dictionary[key] = False
            elif dictionary[key].lower() == 'true':
                dictionary[key] = True
            elif dictionary[key].lower() == 'null':
                dictionary[key] = None
    return dictionary


def check_type(item, type_cls):
    try:
        type_cls(item)
        return True
    except ValueError:
        return False
    except TypeError:
        return False


def check_int(item):
    return check_type(item, int)
