import time

import pymysql
from dbutils.pooled_db import PooledDB

from scraper.log import root_logger

logger = root_logger.get_child('PROXY_STATS.DATABASE')


class MySQLConnection:
    def __init__(self, host, user, password, db, port=3306, charset='utf8mb4'):
        self.pool = self.create_pool(host, user, password, db, port, charset)

    def create_pool(self, host, user, password, db, port, charset):
        pool = PooledDB(
            creator=pymysql,  # the library to connect to your db
            maxconnections=50,  # maximum number of connections allowed at once
            host=host,
            user=user,
            password=password,
            database=db,
            port=port,
            charset=charset
        )
        return pool

    def execute_query(self, query, args=None):
        connection = self.pool.connection()
        cursor = connection.cursor()
        for i in range(3):
            try:
                cursor.execute(query, args)
                connection.commit()
                cursor.close()
                connection.close()
                return cursor.fetchall()

            except pymysql.err.OperationalError as e:
                # Handle deadlock
                error_code, error_message = e.args
                if error_code == 1213:
                    logger.warning(f'Got a deadlock while running a query - retry: {i}')
                    time.sleep(5)
                    continue
            except Exception:
                connection.rollback()
                cursor.close()
                connection.close()
                raise

        cursor.close()
        connection.close()
