from functools import wraps

from flask import make_response


def cache_control(seconds):
    def decorator(f):
        @wraps(f)
        def decorated_function(*args, **kwargs):
            resp = make_response(f(*args, **kwargs))
            resp.headers['Cache-Control'] = f'public, max-age={seconds}'
            resp.headers['Access-Control-Allow-Origin'] = '*'  # For local debugging. Nginx will add the proper headers later.
            return resp

        return decorated_function

    return decorator
