import re
import threading
import time
import traceback

import requests
from flask import Flask
from redis import Redis

redis_conn = Redis(host='localhost', port=6379, db=10)


def do_update():
    redis_conn.set('desu_proxy_target', 'None')
    redis_conn.set('desu_proxy_html', 'Failed to reach desu')
    redis_conn.set('desu_proxy_status_code', 512)
    while True:
        try:
            r = requests.get('https://rentry.org/desudeliveryservice/raw', timeout=10, proxies={"http": 'http://172.0.3.109:9000', "https": 'http://172.0.3.109:9000'})
            domain = re.findall(r'https://(.*?\.trycloudflare\.com)', r.text)[0]
            redis_conn.set('desu_proxy_target', domain)

            res = requests.get(
                url='https://' + domain,
                allow_redirects=False,
                timeout=10,
                proxies={"http": 'http://172.0.3.109:9000', "https": 'http://172.0.3.109:9000'}
            )
            redis_conn.set('desu_proxy_html', res.text)
            redis_conn.set('desu_proxy_status_code', res.status_code)
        except:
            redis_conn.set('desu_proxy_target', 'None')
            redis_conn.set('desu_proxy_html', 'Failed to reach desu')
            redis_conn.set('desu_proxy_status_code', 500)
            traceback.print_exc()
        time.sleep(5)


threading.Thread(target=do_update).start()

app = Flask(__name__)


@app.route('/', defaults={'path': ''})
@app.route('/<path:path>', methods=['GET', 'POST', 'PUT', 'DELETE'])
def catch_all(path):
    if path != '':
        return 'Only serving the status page', 403
    domain = redis_conn.get('desu_proxy_target').decode()
    html_response = redis_conn.get('desu_proxy_html').decode()
    status_code_response = redis_conn.get('desu_proxy_status_code').decode()
    return html_response, 200


if __name__ == '__main__':
    app.run(host='0.0.0.0', threaded=False, processes=15)
