import json
from pathlib import Path


def load_json_with_err(file: Path) -> dict:
    try:
        return json.loads(file.read_text())
    except json.decoder.JSONDecodeError as e:
        print('Failed to load JSON for:', file)
        raise e
