import os
import sys
from pathlib import Path

from tqdm import tqdm

script_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.insert(0, str(Path(script_dir).parent))

from scraper.globals import GLOBALS
from scraper.database.connection import Database, CursorFromConnectionFromPool
from scraper.image import parse_card_metadata
from scraper.webring.insert import insert_webring_character

"""
This script imports webring cards into PostgreSQL. IT ERASES ALL EXISTING DATA!!!
"""

root_path = Path('/mnt/share/to-import/webring/cards')
GLOBALS.hashed_data_path = '/mnt/share/archive/hashed-data/'


def process_card(card_path: Path):
    img_bytes = card_path.read_bytes()
    card_raw, card_parsed, err = parse_card_metadata(card_path, 'webring', only_exceptions=False)
    if err:
        print(err)
        quit(1)
    if not card_parsed:
        return

    author_site = card_path.parent.name
    insert_webring_character(card_parsed, img_bytes, card_raw, source_url=None, author=author_site)


def process_webring_site(site_path: Path):
    cards = sorted(list(site_path.glob('*.png')))
    for card_path in cards:
        process_card(card_path)


Database.initialise(minconn=1, maxconn=100, database="char_archive", user="char_archive", password="hei3ucheet5oochohjongeisahV3mei0", host="172.0.3.101", port=5432)
with CursorFromConnectionFromPool() as cursor:
    cursor.execute("TRUNCATE TABLE webring_character_def")

webring_folders = sorted(list(root_path.glob('*')))
for x in webring_folders:
    assert x.is_dir()

loading_bar = tqdm(total=len(webring_folders), desc='Importing webring', smoothing=0.05, leave=True)
for site_path in webring_folders:
    loading_bar.write(str(site_path))
    process_webring_site(site_path)
    loading_bar.update(1)
