import io
import os
import sys
from pathlib import Path

from PIL import Image
from pydantic import ValidationError
from tqdm import tqdm

script_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.insert(0, str(Path(script_dir).parent))

from scraper.chub.users.insert import insert_chub_user
from scraper.database.connection import Database, CursorFromConnectionFromPool
from scraper.chub.types.chub_user import ChubUser, ChubUserNode
from scraper.paths import create_directory
from iptr.jayson import load_json_with_err

"""
This script imports chub.ai users into PostgreSQL. IT ERASES ALL EXISTING DATA!!!
"""

root_path = Path('/srv/chub-archive/previous-archive/chub.ai/users')
create_directory(root_path)
root_path_images = Path('/srv/chub-archive/archive/hashed-data')
create_directory(root_path_images)
default_avatar = Path('../scraper/chub/users/default-user-avatar.png').expanduser().resolve().absolute()

seen_user_ids = set()


def process_user(user_path: Path):
    png_file = list(user_path.glob('*.png'))
    user_json_file = list(user_path.glob('*.json'))
    if not len(user_json_file):
        return

    try:
        if len(png_file):
            user_avatar = png_file[0]
            Image.open(io.BytesIO(user_avatar.read_bytes()))  # test image
        else:
            user_avatar = default_avatar
    except:
        user_avatar = default_avatar

    # Test JSON data.
    load_json_with_err(user_json_file[0])

    try:
        chub_user_entry = ChubUserNode.parse_raw(user_json_file[0].read_text())
    except (ValidationError, ValueError):
        # who gives a shit
        return

    chub_user = ChubUser(
        user=chub_user_entry,
        png_bytes=user_avatar.read_bytes()
    )

    if chub_user.user.id not in seen_user_ids:
        insert_chub_user(chub_user, root_path_images)
    seen_user_ids.add(chub_user.user.id)


Database.initialise(minconn=1, maxconn=100, database="chub_archive", user="chub_archive", password="eec3naigeeWu4yi0tohbeeB1eek4noom", host="172.0.3.109", port=5432)

with CursorFromConnectionFromPool() as cursor:
    cursor.execute('truncate table chub_user;')

files = sorted(list(root_path.iterdir()))
loading_bar = tqdm(total=len(files), desc='Importing users', smoothing=0.05, leave=True)
for user_path in files:
    loading_bar.write(str(user_path))
    process_user(user_path)
    loading_bar.update(1)
