import json
import os
import sys
from pathlib import Path

from pydantic import ValidationError
from tqdm import tqdm

from scraper.card_types.ccv2.infer import infer_specv2_card

script_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.insert(0, str(Path(script_dir).parent))

from scraper.catbox.catbox import CATBOX_TYPE_STR
from scraper.database.connection import Database, CursorFromConnectionFromPool
from scraper.paths import create_directory
from scraper.image import parse_card_metadata
from scraper.catbox.insert import insert_generic_character

"""
This script imports Catbox cards into PostgreSQL. IT ERASES ALL EXISTING DATA!!!
"""

root_path = Path('/srv/chub-archive/previous-archive/catbox/cards')
create_directory(root_path)
hashed_data_path = Path('/srv/chub-archive/archive/hashed-data')
create_directory(hashed_data_path)


def process_catbox(card_path: Path):
    img_bytes = card_path.read_bytes()
    json_file = Path(str(card_path).strip(card_path.suffix) + '.json')
    if not json_file.is_file():
        card_raw, card_parsed, err = parse_card_metadata(card_path, 'catbox', only_exceptions=True)
        if err:
            print(err)
            quit(1)
        if not card_parsed:
            return
    else:
        card_raw = json_file.read_text()
        try:
            card_parsed = infer_specv2_card(json.loads(card_raw), '', CATBOX_TYPE_STR)
        except (ValidationError, ValueError):
            return

    insert_generic_character(card_parsed, img_bytes, card_raw, hashed_data_path, 'catbox', source_url=None)


Database.initialise(minconn=1, maxconn=100, database="chub_archive", user="chub_archive", password="eec3naigeeWu4yi0tohbeeB1eek4noom", host="172.0.3.109", port=5432)

with CursorFromConnectionFromPool() as cursor:
    cursor.execute('truncate table generic_character_def')

files = sorted(list(root_path.glob('*.png')))
catbox_loading_bar = tqdm(total=len(files), desc='Importing Catbox', smoothing=0.05, leave=True)
for p in files:
    catbox_loading_bar.write(str(p))
    process_catbox(p)
    catbox_loading_bar.update(1)
