import json
import os
import sys
from pathlib import Path

from tqdm import tqdm

from scraper.card_types.ccv2.infer import infer_specv2_card

script_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.insert(0, str(Path(script_dir).parent))

from scraper.database.connection import CursorFromConnectionFromPool, Database
from scraper.booru.insert import insert_booru_character
from scraper.paths import create_directory
from scraper.booru.parse import parse_booru_node

"""
This script imports booru.plus cards into PostgreSQL. IT ERASES ALL EXISTING DATA!!!
"""

root_path = Path('/srv/chub-archive/previous-archive/booru.plus/cards')
create_directory(root_path)
hashed_data_path = Path('/srv/chub-archive/archive/hashed-data')
create_directory(hashed_data_path)


def process_booru(card_path: Path):
    img_bytes = card_path.read_bytes()
    json_file = Path(str(card_path).strip(card_path.suffix) + '.booru.json')
    json_data = json.loads(json_file.read_text())
    node = parse_booru_node(json_data)

    json_card_file = Path(str(card_path).strip(card_path.suffix) + '.json')
    if not json_card_file.is_file():
        return
    card_raw = json_card_file.read_text()
    json_card = json.loads(card_raw)
    card = infer_specv2_card(json_card, specific_author=node.author, source='booru')
    card.data.tags.extend(node.tags)
    insert_booru_character(node, card, img_bytes, card_raw, hashed_data_path)


Database.initialise(minconn=1, maxconn=100, database="chub_archive", user="chub_archive", password="eec3naigeeWu4yi0tohbeeB1eek4noom", host="172.0.3.109", port=5432)
with CursorFromConnectionFromPool() as cursor:
    cursor.execute('truncate table booru_character_def')

files = sorted(list(root_path.rglob('*.png')))
loading_bar = tqdm(total=len(files), desc='Importing booru', smoothing=0.05, leave=True)
for p in files:
    loading_bar.write(str(p))
    process_booru(p)
    loading_bar.update(1)
