#!/usr/bin/env python3
import argparse
import json
import zlib

from psycopg2.extras import RealDictCursor
from tqdm import tqdm

from scraper.database.connection import Database, CursorFromConnectionFromPool


def process_table(rows, table_name, primary_key: tuple):
    for row in tqdm(rows, desc=table_name):
        raw_card = json.loads(zlib.decompress(row['raw']).decode())
        card_def = row['definition']

        try:
            # card = infer_anyspec_card(card_def, source=row['source'])
            #
            # if card_def['data']['extensions']['char_archive'].get('events'):
            #     created_event = card_def['data']['extensions']['char_archive']['events']['created']
            #     if created_event is None:
            #         created_event = datetime.fromtimestamp(0)
            #     card.data.extensions.char_archive.created = parse_date_field(created_event)
            #     card.data.extensions.char_archive.added = row['added']

            # Remove unnessesary data from metadata.
            if row['metadata'].get('created'):
                del row['metadata']['created']
            if row['metadata'].get('source_url'):
                del row['metadata']['source_url']

        except:
            print(row['card_data_hash'], json.dumps(raw_card))
            raise

        with CursorFromConnectionFromPool(cursor_factory=RealDictCursor) as cursor:
            cursor.execute(
                f"UPDATE {table_name} SET metadata = %s WHERE {' AND '.join([f'{k} = %s' for k in primary_key])}",
                (json.dumps(row['metadata'],), *[row[k] for k in primary_key])
            )
            # cursor.execute(f"UPDATE {table_name} SET definition = %s WHERE {' AND '.join([f'{k} = %s' for k in primary_key])}", (card.model_dump_json(), *[row[k] for k in primary_key]))
        tqdm.write(f'{row[primary_key[0]]}')  # -- {card.data.name} -- {card.data.creator}')


def main(args):
    Database.initialise(minconn=1, maxconn=100, host='172.0.3.101', database='char_archive', user='char_archive', password='hei3ucheet5oochohjongeisahV3mei0')
    with CursorFromConnectionFromPool(cursor_factory=RealDictCursor) as cursor:
        cursor.execute("SELECT * FROM webring_character_def ORDER BY added desc" + (' LIMIT 1' if args.test else ''))
        process_table(cursor.fetchall(), 'webring_character_def', ('card_data_hash',))


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--test', action='store_true')
    args = parser.parse_args()
    main(args)
