#!/usr/bin/env python3
import argparse
import json
import zlib

from psycopg2.extras import RealDictCursor
from tqdm import tqdm

from scraper.card_types.infer import infer_anyspec_card
from scraper.card_types.item_extensions import parse_date_field
from scraper.database.connection import Database, CursorFromConnectionFromPool


def process_table(rows, table_name, primary_key: tuple):
    for row in tqdm(rows, desc=table_name):
        raw_card = json.loads(zlib.decompress(row['raw']).decode())
        card_def = row['definition']

        try:
            card = infer_anyspec_card(card_def, source=row['source'])

            if card_def['data']['extensions']['char_archive'].get('events'):
                created_event = card_def['data']['extensions']['char_archive']['events']['created']
                assert created_event is not None
                card.data.extensions.char_archive.created = parse_date_field(created_event)
                card.data.extensions.char_archive.added = row['added']
        except:
            print(row['id'], json.dumps(raw_card))
            raise

        with CursorFromConnectionFromPool(cursor_factory=RealDictCursor) as cursor:
            cursor.execute(f"UPDATE {table_name} SET definition = %s WHERE {' AND '.join([f'{k} = %s' for k in primary_key])}", (card.model_dump_json(), *[row[k] for k in primary_key]))
        tqdm.write(f'{row[primary_key[0]]} -- {card.data.name} -- {card.data.creator}')


def main(args):
    Database.initialise(minconn=1, maxconn=100, host='172.0.3.101', database='char_archive', user='char_archive', password='hei3ucheet5oochohjongeisahV3mei0')
    with CursorFromConnectionFromPool(cursor_factory=RealDictCursor) as cursor:
        cursor.execute("SELECT * FROM booru_character_def ORDER BY added desc" + (' LIMIT 20' if args.test else ''))
        process_table(cursor.fetchall(), 'booru_character_def', ('id',))


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--test', action='store_true')
    args = parser.parse_args()
    main(args)
