init python:

    class TableTennis(renpy.Displayable):

        def __init__(self):

            renpy.Displayable.__init__(self)

            # Some displayables we use.
            self.player_icon = Image(store.n.icon_image())
            self.opponent_icon = Image(store.minigame_table_tennis_partner.icon_image())
            self.ICON_WIDTH = 220
            self.ICON_HEIGHT = 220

            self.paddle = Image("paddle.png")
            self.ball = Image("ping_ball.png")
            self.ctb = Text(_("Click to Begin"), size=48, xalign = 0.5, yalign = 0.1)

            # The sizes of some of the images.
            # default: 8
            self.PADDLE_WIDTH = 8
            # default: 79
            self.PADDLE_HEIGHT = 160
            # default: 23
            self.BALL_WIDTH = 15
            # default: 15
            self.BALL_HEIGHT = 23
            self.COURT_LEFT = 447
            self.COURT_TOP = 214
            self.COURT_BOTTOM = config.screen_height - self.COURT_TOP
            self.PLAYER_ICON_X = self.COURT_LEFT - self.ICON_WIDTH - 50
            self.OPPONENT_ICON_X = config.screen_width - self.COURT_LEFT + 50

            # paddle positions
            self.PLAYER_X = self.COURT_LEFT + 10
            self.COMPUTER_X = config.screen_width - self.PLAYER_X - 10

            # If the ball is stuck to the paddle.
            self.stuck = True

            # The positions of the two paddles.
            self.playery = (self.COURT_BOTTOM - self.COURT_TOP) / 2
            self.computery = self.playery

            # The position, dental-position, and the speed of the
            # ball.
            # default: 88
            self.bx = self.PLAYER_X + 20
            self.by = self.playery
            self.bdx = .5
            self.bdy = .5
            # default: 300.0

            if store.minigame_table_tennis_difficulty == "easy":
                self.original_bspeed = 700.0
                # The speed of the computer.
                # default: 350
                self.computerspeed = int(self.original_bspeed/2) + 85
                self.max_bspeed = 1200

            elif store.minigame_table_tennis_difficulty == "medium":
                self.original_bspeed = 800.0

                # The speed of the computer.
                # default: 350
                self.computerspeed = self.original_bspeed - 150
                self.max_bspeed = 1800

            else:
                self.original_bspeed = 900.0

                # The speed of the computer.
                # default: 350
                self.computerspeed = self.original_bspeed
                self.max_bspeed = 2200

            if store.minigame_table_tennis_instant_win_mode:
                self.computerspeed = 0

            #self.computerspeed = 0
            self.bspeed = self.original_bspeed

            # The time of the past render-frame.
            self.oldst = None

            # The winner.
            self.winner = None

            # amount of leeway for player, if the ball is close but doesnt 
            # actually hit, stills counts as a hit
            self.leeway = 10

        def visit(self):
            return [ self.paddle, self.ball, self.ctb ]

        # Recomputes the position of the ball, handles bounces, and
        # draws the screen.
        def render(self, width, height, st, at):

            # The Render object we'll be drawing into.
            r = renpy.Render(width, height)

            # Figure out the time elapsed since the previous frame.
            if self.oldst is None:
                self.oldst = st

            dtime = st - self.oldst
            self.oldst = st

            # Figure out where we want to move the ball to.
            speed = dtime * self.bspeed
            oldbx = self.bx

            if self.stuck:
                self.by = self.playery
            else:
                self.bx += self.bdx * speed
                self.by += self.bdy * speed

            # Move the computer's paddle. It wants to go to self.by, but
            # may be limited by it's speed limit.
            cspeed = self.computerspeed * dtime
            if abs(self.by - self.computery) <= cspeed:
                self.computery = self.by
            else:
                self.computery += cspeed * (self.by - self.computery) / abs(self.by - self.computery)

            # Handle bounces.

            # Bounce off of top.
            ball_top = self.COURT_TOP + self.BALL_HEIGHT / 2
            if self.by < ball_top:
                self.by = ball_top + (ball_top - self.by)
                self.bdy = -self.bdy
                #renpy.sound.play("ping_beep.wav", channel=0)

            # Bounce off bottom.
            ball_bot = self.COURT_BOTTOM - self.BALL_HEIGHT / 2
            if self.by > ball_bot:
                self.by = ball_bot - (self.by - ball_bot)
                self.bdy = -self.bdy
                #renpy.sound.play("ping_beep.wav", channel=0)

            # This draws a paddle, and checks for bounces.
            def paddle(px, py, hotside, is_player):

                # Render the paddle image. We give it an 800x600 area
                # to render into, knowing that images will render smaller.
                # (This isn't the case with all displayables. Solid, Frame,
                # and Fixed will expand to fill the space allotted.)
                # We also pass in st and at.
                pi = renpy.render(self.paddle, config.screen_width, config.screen_height, st, at)

                # renpy.render returns a Render object, which we can
                # blit to the Render we're making.
                r.blit(pi, (int(px), int(py - self.PADDLE_HEIGHT / 2)))

                if is_player:
                    hit_leeway = self.leeway
                    #hit_leeway = 9999
                else:
                    hit_leeway = 0

                if ( ( py - ( self.PADDLE_HEIGHT / 2 ) - hit_leeway ) ) <= self.by <= ( ( py + ( self.PADDLE_HEIGHT / 2 ) + hit_leeway ) ):

                    hit = False


                    if is_player and self.bdx < 0 and oldbx > self.bx and self.bx <= hotside and oldbx >= px:
                        self.bx = hotside + (hotside - self.bx)
                        self.bdx = -self.bdx
                        hit = True

                    elif not is_player and self.bdx > 0 and oldbx < self.bx and self.bx >= hotside and oldbx <= px + self.PADDLE_WIDTH:
                        self.bx = hotside - (self.bx - hotside)
                        self.bdx = -self.bdx
                        hit = True

                    if hit:
                        #renpy.sound.play("ping_boop.wav", channel=1)
                        self.bspeed *= 1.10
                        self.bspeed = min(self.max_bspeed, self.bspeed)

            # Draw the two paddles.
            paddle(self.PLAYER_X, self.playery, self.PLAYER_X + self.PADDLE_WIDTH, True)
            paddle(self.COMPUTER_X, self.computery, self.COMPUTER_X, False)

            player_icon_render = renpy.render(self.player_icon, config.screen_width, config.screen_height, st, at)
            r.blit(player_icon_render, (self.PLAYER_ICON_X, int(self.playery - self.PADDLE_HEIGHT / 2) - ( int( (self.ICON_HEIGHT - self.PADDLE_HEIGHT) / 2 ) ) ) )

            opponent_icon_render = renpy.render(self.opponent_icon, config.screen_width, config.screen_height, st, at)
            r.blit(opponent_icon_render, (self.OPPONENT_ICON_X, int(self.computery - self.PADDLE_HEIGHT / 2) - ( int( (self.ICON_HEIGHT - self.PADDLE_HEIGHT) / 2 ) ) ) )

            # Draw the ball.
            ball = renpy.render(self.ball, config.screen_width, config.screen_height, st, at)
            r.blit(ball, (int(self.bx - self.BALL_WIDTH / 2),
                          int(self.by - self.BALL_HEIGHT / 2)))

            # Show speed
            #speed_render = renpy.render(Text(str(self.bspeed)), config.screen_width, config.screen_height, st, at)
            #r.blit(speed_render, (790, 60))

            # Show the "Click to Begin" label.
            if self.stuck:

                ctb = renpy.render(Fixed( self.ctb, xysize = ( config.screen_width, config.screen_height ) ), config.screen_width, config.screen_height, st, at)
                r.blit(ctb, (0, 0))


            # Check for a winner.
            if self.bx < -200:
                self.winner = "opponent"

                # Needed to ensure that event is called, noticing
                # the winner.
                renpy.timeout(0)

            elif self.bx > config.screen_width + 200:
                #renpy.log("Original ballspeed: " + str(self.original_bspeed))
                #renpy.log("win ballspeed: " + str(self.bspeed))
                #renpy.log("-----")
                self.winner = "player"
                renpy.timeout(0)

            # Ask that we be re-rendered ASAP, so we can show the next
            # frame.
            renpy.redraw(self, 0)

            # Return the Render object.
            return r

        # Handles events.
        def event(self, ev, x, y, st):

            import pygame

            # Mousebutton down == start the game by setting stuck to
            # false.
            if ev.type == pygame.MOUSEBUTTONDOWN and ev.button == 1:
                self.stuck = False

            if y >= 0 and y <= 1920:
                # Set the position of the player's paddle.
                y = max(y, self.COURT_TOP)
                y = min(y, self.COURT_BOTTOM)
                self.playery = y

            # If we have a winner, return him or her. Otherwise, ignore
            # the current event.
            if self.winner:
                return self.winner
            else:
                raise renpy.IgnoreEvent()

label minigame_table_tennis(partner = k):
    call process_new_location("bg tennis_field")   

    $ no_bust_art = False

    python:
        minigame_table_tennis_player_score = 0
        minigame_table_tennis_partner_score = 0
        minigame_table_tennis_partner_win_threshold = 2

    $ minigame_table_tennis_instant_win_mode = False
    if config.developer:
        "CONFIG/DEVELOPER MODE: Activate incredibly easy mode (win effortlessly)?"
        menu:
            "yes":
                $ minigame_table_tennis_instant_win_mode = True
            "no":
                pass

    if partner:
        $ minigame_table_tennis_partner = partner
    else:
        $ minigame_table_tennis_partner = k

    if minigame_table_tennis_partner == k:
        $ display_multiple_characters([ (n, ""), (k, "") ])
        call process_character(k, appearance = "yea", text = "Sup")
    elif minigame_table_tennis_partner == edna:
        $ diceroll = random.randint(1,3)
        if diceroll == 1:
            $ display_multiple_characters([ (n, "outfit clothesjacket pose handpocket face neutral"), (edna, "outfit clothes pose handclasp face happy blush false") ])
            call process_character(edna, appearance = "pose handclasp face happy blush false", text = "I got the tennis rackets in my bag.")
            call process_character(edna, appearance = "pose handclasp face happy blush false", text = "Let's head on over to the court!")
        elif diceroll == 2:
            $ display_multiple_characters([ (n, "outfit clothesjacket pose handpocket face neutral"), (edna, "outfit clothes pose handhip face neutral blush false") ])
            call process_character(edna, appearance = "pose handhip face neutral blush false", text = "Alright, I got some time to play.")
            call process_character(edna, appearance = "pose handhip face neutral blush false", text = "Make sure to bring plenty of water with you.")
        else:
            $ display_multiple_characters([ (n, "outfit clothesjacket pose handpocket face neutral"), (edna, "outfit clothes pose fisthip face happy blush false") ])
            call process_character(edna, appearance = "pose fisthip face happy blush false", text = "Is this becoming your favorite sport [n.say_name]?")

    window hide
    menu:
        "Easy":
            $ minigame_table_tennis_difficulty = "easy"
        "Medium (Boldness Opportunity!)":
            $ minigame_table_tennis_difficulty = "medium"
        "Hard (Boldness Opportunity!)":
            $ minigame_table_tennis_difficulty = "hard"

    $ diceroll = random.randint(1,2)

    if minigame_table_tennis_partner == k:
        pass
    elif minigame_table_tennis_partner == edna:
        if minigame_table_tennis_difficulty == "easy":
            if diceroll == 1:
                call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "It's best to start off slow.")
                call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "You'll work your way up in no time!")
            else:
                call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "Let me know if I start going too fast.")
                call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "It's a force of habit sometimes!")
        elif minigame_table_tennis_difficulty == "medium":
            if diceroll == 1:
                call process_character(edna, appearance = "pose handhip face neutral blush false", text = "I'll hit with my topspin on occasion.")
                call process_character(edna, appearance = "pose handhip face neutral blush false", text = "Watch out for it!")
            else:
                call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "Since I started playing, I've noticed I can move my feet better.")
                call process_character(edna, appearance = "pose handclasp face happy blush false", text = "It must be helping my joints!")
        else:
            if diceroll == 1:
                call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "You'll feel it in your legs after this!")
                call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "I usually put ice on them.")
            else:
                call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "I've been working on improving my serve.")
                call process_character(edna, appearance = "pose handclasp face happy blush false", text = "Let me see what you think!")

    $ disable_saving()
    $ disable_rollback()
    window hide
    $ clear_characters()

    show screen minigame_table_tennis_score_display

    jump minigame_table_tennis_round
    
    return

screen minigame_table_tennis_score_display:
    text n.say_name + ": " + str(minigame_table_tennis_player_score) xalign 0.05 size 64
    text minigame_table_tennis_partner.say_name + ": " + str(minigame_table_tennis_partner_score) xalign 0.95 size 64

label minigame_table_tennis_round:
    window hide

    python:
        ui.add(TableTennis())
        winner = ui.interact(suppress_overlay=True, suppress_underlay=True)

    window show None

    if winner == "opponent":
        $ minigame_table_tennis_partner_score += 1
        "You lost this round."

    else:
        $ minigame_table_tennis_player_score += 1
        "You won this round!"



    if minigame_table_tennis_player_score >= minigame_table_tennis_partner_win_threshold:
        jump minigame_table_tennis_win
    elif minigame_table_tennis_partner_score >= minigame_table_tennis_partner_win_threshold:
        jump minigame_table_tennis_lose
    else:
        jump minigame_table_tennis_round

    return


label minigame_table_tennis_lose:
    if minigame_table_tennis_partner == k:
        $ display_multiple_characters([ (n, "face curious"), (k, "face happy") ])
        call process_character(k, appearance = "face happy", text = "Yeah!")
    elif minigame_table_tennis_partner == edna:
        if minigame_table_tennis_difficulty == "easy":
            $ display_multiple_characters([ (n, "outfit clothesjacket face curious"), (edna, "outfit clothes pose handclasp face concerned blush false") ])
            call process_character(edna, appearance = "pose handclasp face concerned blush false", text = "Maybe your racket is too heavy for you [n.say_name]?")
        elif minigame_table_tennis_difficulty == "medium":
            $ display_multiple_characters([ (n, "outfit clothesjacket face curious"), (edna, "outfit clothes pose handhip face neutral blush false") ])
            call process_character(edna, appearance = "pose handhip face neutral blush false", text = "Keep your eye on the ball, as they say!")
            call process_character(edna, appearance = "pose handhip face neutral blush false", text = "Don't take your eyes off of it!")
        else:
            $ display_multiple_characters([ (n, "outfit clothesjacket face curious"), (edna, "outfit clothes pose fisthip face neutral blush false") ])
            call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "Almost [n.say_name]!")
            call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "Keep working at it!")

    jump minigame_table_tennis_end

    return

label minigame_table_tennis_win:
    $ renpy.scene('screens')
    show screen hud
    $ minigame_table_tennis_win_money = 4
    if minigame_table_tennis_partner == k:
        if minigame_table_tennis_difficulty == "easy":
            $ k.add_points(2, minigame = True)
            $ minigame_table_tennis_win_money = 4
            $ display_multiple_characters([ (n, "face happy"), (k, "face concerned") ])
            call process_character(k, appearance = "face concerned", text = "Damn")
        elif minigame_table_tennis_difficulty == "medium":
            call add_points_and_boldness(k, 3, 1, minigame = True)
            $ minigame_table_tennis_win_money = 6
            $ display_multiple_characters([ (n, "face happy"), (k, "face concerned") ])
            call process_character(k, appearance = "face concerned", text = "Damn")
        else:
            call add_points_and_boldness(k, 4, 1, minigame = True)
            $ minigame_table_tennis_win_money = 8
            $ display_multiple_characters([ (n, "face happy"), (k, "face concerned") ])
            call process_character(k, appearance = "face concerned", text = "Damn")
    elif minigame_table_tennis_partner == edna:
        if minigame_table_tennis_difficulty == "easy":
            $ edna.add_points(2, minigame = True)
            $ minigame_table_tennis_win_money = 4
            $ display_multiple_characters([ (n, "outfit clothesjacket face happy"), (edna, "outfit clothes pose fisthip face neutral blush false") ])
            call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "You're more than capable at this [n.say_name].")
            call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "I know you can handle the next level!")
        elif minigame_table_tennis_difficulty == "medium":
            call add_points_and_boldness(edna, 3, 1, minigame = True)
            $ minigame_table_tennis_win_money = 6
            $ display_multiple_characters([ (n, "outfit clothesjacket face happy"), (edna, "outfit clothes pose handclasp face happy blush false") ])
            call process_character(edna, appearance = "pose handclasp face happy blush false", text = "And my grandson claims victory!")
        else:
            call add_points_and_boldness(edna, 4, 1, minigame = True)
            $ minigame_table_tennis_win_money = 8
            $ diceroll = random.randint(1,2)
            if diceroll == 1:
                $ display_multiple_characters([ (n, "outfit clothesjacket face happy"), (edna, "outfit clothes pose fisthip face shock blush false") ])
                call process_character(edna, appearance = "pose fisthip face shock blush false", text = "You smoked me [n.say_name]!")
                call process_character(edna, appearance = "pose fisthip face shock blush false", text = "Pretty soon you'll be getting trophies!")
            else:
                $ display_multiple_characters([ (n, "outfit clothesjacket face happy"), (edna, "outfit clothes pose handhip face happy blush false") ])
                call process_character(edna, appearance = "pose handhip face happy blush false", text = "You've got a good swing [n.say_name]!")
                call process_character(edna, appearance = "pose handhip face happy blush false", text = "And you're light on your feet!")

    python hide:
        inventory.add_money(minigame_table_tennis_win_money, minigame = True)
        narrator("Got $" + str(minigame_table_tennis_win_money) + " for winning.")

    jump minigame_table_tennis_end

    return

label minigame_table_tennis_end:
    $ renpy.scene('screens')

    $ enable_saving()
    $ renpy.block_rollback()
    $ enable_rollback()

    call process_end_of_minigame("minigame_table_tennis")

    return