init python:
    def minigame_slide_puzzle_random_picture():
        pictures = []
        pictures.append("images/bg/house/bg backyard_daytime.png")
        pictures.append("images/bg/house/bg kira_room_daytime.png")
        pictures.append("images/bg/house/bg kitchen_daytime.png")
        pictures.append("images/bg/house/bg living_room_daytime.png")
        pictures.append("images/bg/house/bg nate_room_daytime.png")
        pictures.append("images/bg/house/bg sam_room_daytime.png")
        pictures.append("images/bg/house/bg sam_room_evening.png")
        pictures.append("images/bg/house/bg simone_room_daytime.png")
        pictures.append("images/bg/house/bg hallway_daytime.png")
        return random.choice(pictures)

    def minigame_slide_puzzle_perform_swap(old_row, old_col, new_row, new_col, puzzle_piece):
        store.minigame_slide_puzzle_layout[new_row][new_col] = puzzle_piece
        store.minigame_slide_puzzle_layout[old_row][old_col] = None
        puzzle_piece.row = new_row
        puzzle_piece.column = new_col

        # refresh the screen
        renpy.restart_interaction()


        if not store.minigame_slide_puzzle_check_for_win:
            return

        if minigame_slide_puzzle_test_win():
            renpy.call("minigame_slide_puzzle_win")
                
        return

    def minigame_slide_puzzle_test_win():
        test_index = 0

        for row_i in range(0, store.minigame_slide_puzzle_rows):
            for displayable in minigame_slide_puzzle_layout[row_i]:
                if displayable:
                    if displayable.index != test_index:
                        return False

                test_index += 1

        return True

    class Slide_Puzzle_Piece(renpy.display.behavior.ImageButton):
        def __init__(self, child, index, row = 0, column = 0, **kwargs):
            self.row = row
            self.column = column
            self.index = index

            self.crop_x = (self.index % store.minigame_slide_puzzle_rows) * store.minigame_slide_puzzle_piece_width
            self.crop_y = (math.floor(self.index / float( store.minigame_slide_puzzle_rows ) )) * store.minigame_slide_puzzle_piece_height
            self.crop_width = store.minigame_slide_puzzle_piece_width
            self.crop_height = store.minigame_slide_puzzle_piece_height

            self.border_color = "#a223cc"

            # Create a transform, that can adjust the child.
            t = Transform(child, crop = (self.crop_x, self.crop_y, self.crop_width, self.crop_height ) )

            idle_image = t

            # Pass additional properties on to the renpy.Displayable
            # constructor.
            super(Slide_Puzzle_Piece, self).__init__(idle_image = idle_image, clicked = self.slide_puzzle_click_function, **kwargs)


        def slide_puzzle_click_function(self):
            if store.minigame_slide_puzzle_disable_puzzle_interaction:
                return None

            old_row = self.row
            old_col = self.column
            should_swap = False

            # check above
            if old_row != 0:
                if store.minigame_slide_puzzle_layout[old_row - 1][old_col] is None:
                    self.perform_swap(old_row -1, old_col)
                    return

            # check below
            if old_row != store.minigame_slide_puzzle_rows - 1:
                if store.minigame_slide_puzzle_layout[old_row + 1][old_col] is None:
                    self.perform_swap(old_row + 1, old_col)
                    return

            # check left
            if old_col != 0:
                if store.minigame_slide_puzzle_layout[old_row][old_col - 1] is None:
                    self.perform_swap(old_row, old_col - 1)
                    return

            # check right
            if old_col != store.minigame_slide_puzzle_columns - 1:
                if store.minigame_slide_puzzle_layout[old_row][old_col + 1] is None:
                    self.perform_swap(old_row, old_col + 1)
                    return

            return

        def perform_swap(self, new_row, new_col):
            minigame_slide_puzzle_perform_swap(self.row, self.column, new_row, new_col, self)

            return

        def render(self, width, height, st, at):
            render = super(Slide_Puzzle_Piece, self).render(width, height, st, at)

            if self.is_focused() and not store.minigame_slide_puzzle_disable_puzzle_interaction:
                if 1 + 1 == 3:
                    hover_black = Solid("#000000", xsize = self.crop_width, ysize = self.crop_height)
                    hover_black_t = Transform(hover_black, alpha = 0.5 )
                    render.blit( renpy.render(hover_black_t, width, height, st, at), ( 0,  0), False)
                else:
                    hover_border_size = 10

                    top_hover_border = Fixed( Solid(self.border_color, xsize = self.crop_width, ysize = hover_border_size, xalign = 0.0, yalign = 0.0), xysize = ( int( render.width ), int( render.height ) ) )
                    bottom_hover_border = Fixed( Solid(self.border_color, xsize = self.crop_width, ysize = hover_border_size, xalign = 0.0, yalign = 1.0), xysize = ( int( render.width ), int( render.height ) ) )

                    left_hover_border = Fixed( Solid(self.border_color, xsize = hover_border_size, ysize = self.crop_height, xalign = 0.0, yalign = 0.0), xysize = ( int( render.width ), int( render.height ) ) )
                    right_hover_border = Fixed( Solid(self.border_color, xsize = hover_border_size, ysize = self.crop_height, xalign = 1.0, yalign = 0.0), xysize = ( int( render.width ), int( render.height ) ) )

                    render.blit( renpy.render(top_hover_border, width, height, st, at), ( 0,  0), False)
                    render.blit( renpy.render(bottom_hover_border, width, height, st, at), ( 0,  0), False)
                    render.blit( renpy.render(left_hover_border, width, height, st, at), ( 0,  0), False)
                    render.blit( renpy.render(right_hover_border, width, height, st, at), ( 0,  0), False)

            if store.minigame_slide_puzzle_difficulty != "medium":
                text = Fixed( Text(str(self.index + 1), xalign = 0.5, yalign = 0.5, size = 64), xysize = ( int( render.width ), int( render.height ) ) )
                render.blit(renpy.render( text, width, height, st, at), ( 0,  0), False)

            return render

screen slide_puzzle_screen:
    vbox:
        xalign 0.5
        yalign 0.5
        for row_i in range(0, minigame_slide_puzzle_rows):
            hbox:
                for displayable in minigame_slide_puzzle_layout[row_i]:
                    if displayable:
                        add displayable
                    else:
                        null width minigame_slide_puzzle_piece_width height minigame_slide_puzzle_piece_height
                    null width 2
            null height 2

    if not minigame_slide_puzzle_disable_puzzle_interaction:
        textbutton "Give Up" action Jump("minigame_slide_puzzle_too_slow") xalign 0.99 yalign 0.99

label minigame_slide_puzzle(partner = None):
    call process_scene_beginning
    call minigame_slide_puzzle_intro(partner)
    call minigame_slide_puzzle_initialize
    call minigame_slide_puzzle_begin

    return



label minigame_slide_puzzle_initialize:

    python:
        if minigame_slide_puzzle_difficulty == "hard":
            minigame_slide_puzzle_rows = 4
            minigame_slide_puzzle_columns = 4
        else:
            minigame_slide_puzzle_rows = 3
            minigame_slide_puzzle_columns = 3

        if minigame_slide_puzzle_difficulty == "easy":
            minigame_slide_puzzle_time_limit = False
        else:
            minigame_slide_puzzle_time_limit = True

        if minigame_slide_puzzle_difficulty == "medium":
            minigame_countdown_duration = 300
        elif minigame_slide_puzzle_difficulty == "hard":
            minigame_countdown_duration = 600

        minigame_slide_puzzle_gap_row = minigame_slide_puzzle_rows - 1
        minigame_slide_puzzle_gap_column = minigame_slide_puzzle_columns - 1
        minigame_slide_puzzle_layout = []
        minigame_slide_puzzle_layout_slot_index = 0
        minigame_slide_puzzle_layout_width = 1280
        minigame_slide_puzzle_layout_height = 720
        minigame_slide_puzzle_piece_width = int( minigame_slide_puzzle_layout_width / float( minigame_slide_puzzle_rows ) )
        minigame_slide_puzzle_piece_height = int( minigame_slide_puzzle_layout_height / float( minigame_slide_puzzle_columns ) )
        minigame_slide_puzzle_base_displayable_full_path = minigame_slide_puzzle_random_picture()
        minigame_slide_puzzle_check_for_win = False
        minigame_slide_puzzle_disable_puzzle_interaction = False
        minigame_slide_puzzle_scrambled_at_least_once = False
        minigame_slide_puzzle_times_to_scramble = 80

        if config.developer and 1 == 2:
            #minigame_slide_puzzle_time_limit = True
            #minigame_countdown_duration = 6
            minigame_slide_puzzle_times_to_scramble = 1

        minigame_slide_puzzle_base_displayable = Transform(Image(minigame_slide_puzzle_base_displayable_full_path), size = (minigame_slide_puzzle_layout_width, minigame_slide_puzzle_layout_height ))

        for row_i in range(0, minigame_slide_puzzle_rows):
            minigame_slide_puzzle_layout.append([])
            for col_i in range(0, minigame_slide_puzzle_columns):
                if minigame_slide_puzzle_gap_row != row_i or minigame_slide_puzzle_gap_column != col_i:
                    minigame_slide_puzzle_layout[row_i].append(Slide_Puzzle_Piece(minigame_slide_puzzle_base_displayable, minigame_slide_puzzle_layout_slot_index, row = row_i, column = col_i ))
                else:
                    minigame_slide_puzzle_layout[row_i].append(None)
                minigame_slide_puzzle_layout_slot_index += 1

        while not minigame_slide_puzzle_scrambled_at_least_once or minigame_slide_puzzle_test_win():
            minigame_slide_puzzle_scrambled_at_least_once = True

            for i in range(0, minigame_slide_puzzle_times_to_scramble):
                candidates =  []

                old_row = minigame_slide_puzzle_gap_row
                old_col = minigame_slide_puzzle_gap_column

                # check above
                if old_row != 0:
                    candidates.append( (old_row - 1, old_col) )

                # check below
                if old_row != store.minigame_slide_puzzle_rows - 1:
                    candidates.append( (old_row + 1, old_col) )

                # check left
                if old_col != 0:
                    candidates.append( (old_row, old_col - 1) )

                # check right
                if old_col != store.minigame_slide_puzzle_columns - 1:
                    candidates.append( (old_row, old_col + 1) )

                # choose
                candidate = random.choice(candidates)
                new_row = candidate[0]
                new_col = candidate[1]

                puzzle_piece_to_swap = minigame_slide_puzzle_layout[new_row][new_col]
                minigame_slide_puzzle_perform_swap(new_row, new_col, old_row, old_col, puzzle_piece_to_swap)
                minigame_slide_puzzle_gap_row = new_row
                minigame_slide_puzzle_gap_column = new_col

        minigame_slide_puzzle_check_for_win = True

    

    return

label minigame_slide_puzzle_begin:
    $ quick_menu = False
    call bust_art_background("bg black")
    pause 0.5

    show screen slide_puzzle_screen
    with Dissolve(0.75)
    $ quick_menu = True

    if minigame_slide_puzzle_time_limit:
        call minigame_countdown(minigame_countdown_duration, "minigame_slide_puzzle_too_slow")

    call screen hard_block_screen

    return

label minigame_slide_puzzle_intro(partner = None):
    $ no_bust_art = False

    if config.developer and 1 == 2:
        "DEBUG/DEVELOPER MODE: Reduced difficulty."

    if partner:
        $ minigame_slide_puzzle_partner = partner
    else:
        $ minigame_slide_puzzle_partner = si

    if minigame_slide_puzzle_partner == si:
        $ diceroll = random.randint(1,3)

        if diceroll == 1:
            $ display_multiple_characters([ (n, ""), (si, "pose handsup") ], reset = True)
            call process_character(si, appearance = "pose handsup", text = "I just finished one.")
            call process_character(si, appearance = "pose handsup", text = "You should give it a try.")
        elif diceroll == 2:
            $ display_multiple_characters([ (n, ""), (si, "pose armunder face happy") ], reset = True)
            call process_character(si, appearance = "pose armunder face happy", text = "I don't know how some people finish these so fast!")
        else:
            $ display_multiple_characters([ (n, ""), (si, "pose handsfront face neutral") ], reset = True)
            call process_character(si, appearance = "pose handsfront face neutral", text = "Your young brain can handle these.")
            call process_character(si, appearance = "pose handsfront face happy", text = "Unlike your mom here!")
    elif minigame_slide_puzzle_partner == sa:
        if not minigame_sliding_puzzle_sam_intro_done:
            $ minigame_sliding_puzzle_sam_intro_done = True
            $ display_multiple_characters([ (n, ""), (sa, "pose handsbehind face neutral") ], reset = True)

            if "minigame_slide_puzzle_first_time_intro" in si.conversations_completed:
                call process_character(sa, appearance = "pose handsbehind face neutral", text = "I heard Mom is trying out these new puzzles?")
                call process_character(n, appearance = "pose handpocket face neutral", text = "Yeah.")
                call process_character(n, appearance = "pose handpocket face neutral", text = "She said they are good for memory.")
            else:
                call process_character(sa, appearance = "pose handsbehind face neutral", text = "Mom told me about these puzzles she's been doing.")
                call process_character(n, appearance = "pose handpocket face neutral", text = "Oh yeah?")
                call process_character(n, appearance = "pose handpocket face neutral", text = "What are they?")
                call process_character(sa, appearance = "pose handface face neutral", text = "I think they're called \"sliding\" puzzles?")
                call process_character(sa, appearance = "pose handface face neutral", text = "Mom says they help her with memory.")
                call process_character(n, appearance = "pose handpocket face neutral", text = "Interesting...")

            call process_character(sa, appearance = "pose leaning face neutral", text = "I think we should try some of them!")
            call process_character(sa, appearance = "pose handface face curious", text = "Doing math all the time fries my brain...")
            call process_character(n, appearance = "pose handfist face neutral", text = "Sure!")
            call process_character(n, appearance = "pose handfist face neutral", text = "I'm up for some puzzle action!")
            call process_character(sa, appearance = "pose leaning face happy", text = "Nice!")
            call process_character(sa, appearance = "pose leaning face happy", text = "Let me get some for us!")

            call character_leave_dissolve(sa)
            $ renpy.pause(1)

            call process_character(sa, appearance = "pose handsbehind face neutral", text = "Looks like there are different levels of challenge for them!")
            call process_character(sa, appearance = "pose handface face neutral", text = "I wonder what level we should start with...")

        else:
            $ diceroll = random.randint(1,3)
            if diceroll == 1:
                $ display_multiple_characters([ (n, ""), (sa, "pose handface face neutral") ], reset = True)
                call process_character(sa, appearance = "pose handface face neutral", text = "I'll take this over math for sure!")
            elif diceroll == 2:
                $ display_multiple_characters([ (n, ""), (sa, "pose leaning face neutral") ], reset = True)
                call process_character(sa, appearance = "pose leaning face neutral", text = "These puzzles should be in a video game!")
            else:
                $ display_multiple_characters([ (n, ""), (sa, "pose handsbehind face neutral") ], reset = True)
                call process_character(sa, appearance = "pose handsbehind face neutral", text = "I wonder what puzzle we should try this time?")



    window hide
    menu:
        "Easy":
            $ minigame_slide_puzzle_difficulty = "easy"
        "Medium (Boldness Opportunity!)":
            $ minigame_slide_puzzle_difficulty = "medium"
        "Hard (Boldness Opportunity!)":
            $ minigame_slide_puzzle_difficulty = "hard"

    if minigame_slide_puzzle_partner == si:
        if minigame_slide_puzzle_difficulty == "easy":
            call process_character(si, appearance = "pose handsfront face neutral", text = "These puzzles are pretty relaxing.")
        elif minigame_slide_puzzle_difficulty == "medium":
            call process_character(si, appearance = "pose handsup face neutral", text = "Just think it out, and you'll solve it.")
        else:
            call process_character(si, appearance = "pose armunder face neutral", text = "I'd take your time with this one sweetie!")
    elif minigame_slide_puzzle_partner == sa:
        if minigame_slide_puzzle_difficulty == "easy":
            call process_character(sa, appearance = "pose handsbehind face neutral", text = "Let's take it easy this time!")
        elif minigame_slide_puzzle_difficulty == "medium":
            call process_character(sa, appearance = "pose handsbehind face neutral", text = "There's definitely a strategy to it!")
            call process_character(sa, appearance = "pose handsbehind face neutral", text = "I've almost got the hang of it!")
        else:
            call process_character(sa, appearance = "pose handface face curious", text = "I'm focusing my brainpower on this one!")


    $ disable_saving()
    $ disable_rollback()
    window hide
    $ clear_characters()

    return

label minigame_slide_puzzle_first_time_intro:
    call process_conversation_beginning([ (n, ""), (si, "pose armunder face neutral") ])

    call process_character(si, appearance = "pose armunder face neutral", text = "Now where did I put that oven mitt...")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Hi Mom!")
    call process_character(si, appearance = "pose armunder face neutral", text = "Hi sweetie.")
    call process_character(n, appearance = "pose behindhead face neutral", text = "Did you lose something?")
    call process_character(si, appearance = "pose handsfront face neutral", text = "Oh I just was looking for my oven mitt.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "I completely forgot where I put it.")
    call process_character(n, appearance = "pose twohandfist face happy", text = "I found it!")
    call process_character(si, appearance = "pose handsup face happy", text = "Oh! Thank you [n.say_name]!")
    call process_character(si, appearance = "pose handsup face happy", text = "I swear I'd lose my head if it wasn't on my neck!")
    call process_character(n, appearance = "pose handpocket face neutral", text = "What do you mean Mom?")
    call process_character(si, appearance = "pose armunder face neutral", text = "Since this move I've had to juggle so many things to remember.")
    call process_character(si, appearance = "pose armunder face neutral", text = "The last thing I need is to start forgetting what I have to do.")
    call process_character(n, appearance = "pose handpocket face concerned", text = "How do you manage to remember everything?")
    call process_character(si, appearance = "pose handsup face neutral", text = "Well...")
    call process_character(si, appearance = "pose handsup face neutral", text = "I've started working on these puzzle games.")
    call process_character(n, appearance = "pose behindhead face neutral", text = "Puzzle games?")
    call process_character(si, appearance = "pose handsup face happy", text = "I knew you'd be curious when you heard the word \"games!\"")
    call process_character(si, appearance = "pose armunder face neutral", text = "One of them involves sliding puzzles.")
    call process_character(si, appearance = "pose armunder face neutral", text = "You have these out of order pieces of an image.")
    call process_character(si, appearance = "pose armunder face neutral", text = "And you have to arrange them back to normal.")
    call process_character(n, appearance = "pose handpocket face curious", text = "Hm, interesting...")
    call process_character(si, appearance = "pose armunder face neutral", text = "The other is a \"repeat pattern\" game.")
    call process_character(si, appearance = "pose armunder face neutral", text = "You'll see a flashing set of colors...")
    call process_character(si, appearance = "pose armunder face neutral", text = "And then you repeat the pattern on your own.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "I heard they're good for brain memory.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "So I figured I'd give them a try.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "Plus, the concept is very simple.")
    call process_character(si, appearance = "pose handsfront face happy", text = "Something I appreciate!")
    call process_character(n, appearance = "pose twohandfist face neutral", text = "Can I try them?")
    call process_character(si, appearance = "pose handsup face happy", text = "Of course!")
    call process_character(si, appearance = "pose handsfront face neutral", text = "I have some different sliding puzzles you can try out.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "Or you can put your memory to the test with some pattern puzzles.")
    call process_character(si, appearance = "pose handsfront face happy", text = "Some of them are challenging!")
    call process_character(si, appearance = "pose handsup face neutral", text = "But if you take your time and think it out, you'll solve them I'm sure!")

    call process_end_of_conversation("minigame_slide_puzzle_first_time_intro", si, priority = False, considered_scene = True, override_scene_limit = True)

    return

label minigame_slide_puzzle_win:
    $ minigame_slide_puzzle_disable_puzzle_interaction = True
    call hide_minigame_countdown
    pause 1.0
    hide screen slide_puzzle_screen
    hide screen hard_block_screen
    
    if minigame_slide_puzzle_difficulty == "easy":
        $ minigame_slide_puzzle_win_money = 4

    elif minigame_slide_puzzle_difficulty == "medium":
        $ minigame_slide_puzzle_win_money = 6
    else:
        $ minigame_slide_puzzle_win_money = 8

    $ renpy.pause(0.25)
    if minigame_slide_puzzle_partner == si:
        if minigame_slide_puzzle_difficulty == "easy":
            $ display_multiple_characters([ (n, ""), (si, "pose handsup face happy") ], reset = True)
            $ si.add_points(3, minigame = True)
            call process_character(si, appearance = "pose handsup face happy", text = "Good job [n.say_name]!")

        elif minigame_slide_puzzle_difficulty == "medium":
            $ display_multiple_characters([ (n, ""), (si, "") ], reset = True)
            call add_points_and_boldness(si, 4, 1, minigame = True)
            call process_character(si, appearance = "pose handsup face happy", text = "You're getting good!")
        else:
            $ display_multiple_characters([ (n, ""), (si, "pose handsup face happy") ], reset = True)
            call add_points_and_boldness(si, 5, 1, minigame = True)
            call process_character(si, appearance = "pose handsup face happy", text = "Excellent [n.say_name]! Excellent!")
    elif minigame_slide_puzzle_partner == sa:
        if minigame_slide_puzzle_difficulty == "easy":
            $ display_multiple_characters([ (n, ""), (sa, "pose handface face happy") ])
            $ sa.add_points(3, minigame = True)
            call process_character(sa, appearance = "pose handface face happy", text = "Hey, not bad!")
        elif minigame_slide_puzzle_difficulty == "medium":
            $ display_multiple_characters([ (n, ""), (sa, "pose handface face happy") ])
            call add_points_and_boldness(sa, 4, 1, minigame = True)
            call process_character(sa, appearance = "pose handface face happy", text = "Oh, so that's how it's done!")
            call process_character(sa, appearance = "pose handface face happy", text = "Nice [n.say_name]!")
        else:
            $ display_multiple_characters([ (n, ""), (sa, "pose handface face happy") ])
            call add_points_and_boldness(sa, 5, 1, minigame = True)
            call process_character(sa, appearance = "pose handface face happy", text = "Wow!")
            call process_character(sa, appearance = "pose handface face happy", text = "I didn't even see that solution!")
            call process_character(sa, appearance = "pose handface face happy", text = "You're a puzzle wizard [n.say_name]!")


    show screen hud
    python hide:
        inventory.add_money(minigame_slide_puzzle_win_money, minigame = True)
        narrator("Got $" + str(minigame_slide_puzzle_win_money) + " for winning.")

    call minigame_slide_puzzle_end
        
    return

label minigame_slide_puzzle_too_slow:
    $ minigame_slide_puzzle_disable_puzzle_interaction = True
    call hide_minigame_countdown
    pause 1.0
    hide screen slide_puzzle_screen
    hide screen hard_block_screen

    if minigame_slide_puzzle_partner == si:
        if minigame_slide_puzzle_difficulty == "easy":
            $ display_multiple_characters([ (n, "face curious"), (si, "pose handsup face curious") ])
            call process_character(si, appearance = "pose handsup face curious", text = "I hope those video games aren't making this tougher.")
        else:
            $ display_multiple_characters([ (n, "face curious"), (si, "pose handsfront face neutral") ])
            call process_character(si, appearance = "pose handsfront face neutral", text = "You'll get the hang of it.")
    elif minigame_slide_puzzle_partner == sa:
        if minigame_slide_puzzle_difficulty == "easy":
            $ display_multiple_characters([ (n, "face curious"), (sa, "pose handface face curious") ])
            call process_character(sa, appearance = "pose handface face curious", text = "Guess our memory isn't too good, huh?")
        else:
            $ display_multiple_characters([ (n, "face curious"), (sa, "pose handface face curious") ])
            call process_character(sa, appearance = "pose handface face curious", text = "Aw, and we were getting there!")

    call minigame_slide_puzzle_end

    return

label minigame_slide_puzzle_end:
    $ renpy.scene('screens')
    $ minigame_slide_puzzle_layout = None
    $ minigame_slide_puzzle_base_displayable = None

    $ enable_saving()
    $ renpy.block_rollback()
    $ enable_rollback()

    call process_end_of_minigame("minigame_slide_puzzle")

    return