label nate_room_empty:
    $ renpy.set_return_stack([]) 
    $ renpy.checkpoint()
    $ quick_menu = True
    $ enable_saving()
    $ enable_rollback()
    show screen hud_zone_select
    show screen hud
    # $ renpy.show(stats.current_location.background())
    python hide:
        renpy.start_predict_screen("gallery")
        for char in npc_list():
            renpy.start_predict_screen("character_gallery", char)

    python:
        choice_list = []

        if not wholesome_mode:
            choice_list.append( ("Sleep", "day_manual_sleep") )
            if "finale_scene" in store.scenes_completed:
                if not epilogue_completed:
                    choice_list.append( ("View the Epilogue (New!)", "epilogue") )
                else:
                    choice_list.append( ("View the Epilogue", "epilogue") )

                choice_list.append( ("Have a Pool Party", "nate_room_finale_scene_revisit_confirm") )
            choice_list.append( ("Minigame", "nate_room_minigame") )
            choice_list.append( ("Stats", "nate_room_stats") )
            choice_list.append( ("Shopping", "nate_room_shopping") )
            choice_list.append( ("Rename Characters", "nate_room_rename_characters") )

        choice_list.append( ("Gallery", "nate_room_gallery") )
        choice_list.append( ("Changelog", "nate_room_changelog") )

        if config.developer:
            choice_list.append( ("(DEBUG) Add 2 Boldness Points", "debug_boldness_2") )
            choice_list.append( ("(DEBUG) Add 999 Boldness Points", "debug_boldness_999") )
            choice_list.append( ("(DEBUG) Add max money", "debug_max_money") )

        choice_list.append( ("Back", "back") )

        chosen_option = renpy.display_menu(choice_list)

    if chosen_option == "back":
        call navigation_menu()
    else:
        $ renpy.call(chosen_option)

    return

label nate_room_finale_scene_revisit_confirm:
    "{i}Call everyone to setup a party?{/i}"
    menu:
        "Yes":
            jump finale_scene_revisit
        "No":
            jump nate_room_empty

    return

label nate_room_gallery:
    jump gallery
    return

label nate_room_rename_characters:

    $ renpy.scene('screens')

    $ process_character(si, "position right")
    call change_character_name(si, "My Mom")

    $ clear_characters()
    $ process_character(k, "position right")
    call change_character_name(k, "My big sis")

    $ clear_characters()
    $ process_character(sa, "position right")
    call change_character_name(sa, "My twin sister")

    if had_julia_arrived_scene:
        $ clear_characters()
        $ process_character(julia, "position right")
        call change_character_name(julia, "My cousin")

    if had_janet_intro_scene:
        $ clear_characters()
        $ process_character(janet, "position right")
        call change_character_name(janet, "My Aunt")

    if had_edna_intro_scene:
        $ clear_characters()
        $ process_character(edna, "position right")
        call change_character_name(edna, "My Grandma")

    $ clear_characters()
    $ process_character(n, "position right")
    call change_character_name(n, "My name")

    python:
        last_name = renpy.input("My last name", default = last_name, length = 14)

    call update_last_names
    $ clear_characters()

    call nate_room_empty

    return

label nate_room_changelog:
    $ quick_menu = False
    $ renpy.scene('screens')
    show screen changelog
    pause
    $ renpy.scene('screens')
    jump nate_room_empty
    return

label nate_room_shopping:
    menu:
        "General Goods":
            call nate_room_shopping_general
        "Back":
            call nate_room_empty

    return

label nate_room_shopping_general:
    window hide
    call buy_menu(visible_items_with_tag("general"), "nate_room_shopping", "nate_room_shopping_general")
    return

label nate_room_stats:
    call screen stats

    return

label nate_room_minigame:
    menu:
        "Game Review Typing Minigame":
            call minigame_typing_review
        "Back":
            call nate_room_empty
    return

label nate_room_computer_buy:
    $ renpy.call_screen("buy_menu", inventory.store_buy_list_nate_computer(), "nate_room_empty", "nate_room_computer_buy")
    return