screen intro_title:
    add Solid("#000")
    vbox:
        xalign 0.5
        if not persistent.use_incestral_awakening_name:
            text "Insexual" size 360 xalign 0.5
        else:
            text "Incestral" size 360 xalign 0.5

        text "Awakening" size 360 xalign 0.5

label intro_0:
    $ renpy.set_return_stack([]) 
    $ renpy.block_rollback()
    $ renpy.scene('screens')
    $ started_main_game = True
    call clear_and_reset_characters

    if wholesome_mode:
        call intro_4

    call bust_art_background("bg black")
    $ play_music("audio/music/Daily_Music_01.ogg", fadein = 2.0, fadeout = 1.0)
    "{i}Beep! Beep! Beep!{/i}"
    "{i}Mmph...\nYawn...{p=1.0}So glad school is still out for a while.{/i}"
    "{i}I think I'll lay here in bed for a little longer.{/i}"
    "{i}This has been a whirlwind start to the summer.{/i}"
    "{i}It feels like it went by so fast.{/i}"

    call bust_art_background("bg family_portrait")
    "{i}Our old home got sold in a couple weeks.{/i}"
    "{i}Moving trucks arrived a few days later.{/i}"
    "{i}And then we were in our new home.{/i}"
    "{i}It went surprisingly smooth.{/i}"
    "{i}But that's because of my Mom's organizing.{/i}"

    $ process_character(si, "position right")
    "{i}I've never known anyone nicer than my Mom.{/i}"
    call change_character_name(si, "Her name is...")
    "{i}Her name is [si.say_name].{/i}"
    "{i}She's been protective to all of us since we were little.\n{/i}"
    "{i}Whether it's the food we eat, the school we attend, my Mom is always looking out for what is best for us.{/i}"
    "{i}I haven't seen her do anything else other than taking care of us.{/i}"
    "{i}Sometimes I feel like she's putting too much pressure on herself.{/i}"
    "{i}She's trying to be the perfect mother for us, but she needs us to help her too.{/i}"
    "{i}Speaking of perfect...{/i}"

    $ clear_characters()
    $ process_character(k, "position right")
    call change_character_name(k, "My big sis...")
    "{i}My big sis [k.say_name].{/i}"
    "{i}And I do mean \"big\" sis.{/i}"
    "{i}She's really tall.{/i}"
    "{i}Mom said she must have inherited some \"Amazon\" genes from our ancestors.{/i}"
    "{i}That height has definitely come in handy for her...{/i}"
    "{i}She's won practically every sport game she's ever played in.{/i}"
    "{i}Basketball, Hockey, Baseball...{/i}"
    "{i}She even was the quarterback at her previous school.{/i}"
    "{i}And won 3 championships!{/i}"
    "{i}She tried out for the Olympics in track and field.{/i}"
    "{i}Mom thought for sure she would easily win a gold medal.{/i}"
    "{i}But I guess she failed to qualify.{/i}"
    "{i}She said her breasts got too big and slowed her down.{/i}"
    "{i}Now she works as a fitness instructor at the local gym.{/i}"
    "{i}I think she can lift heavier weights than most of the guys...{/i}"
    "{i}She's very forward, but she always helps me out and gives advice.{/i}"
    "{i}She's got me and my sister's back.{/i}"
    "{i}Oh!{/i}"

    $ clear_characters()
    $ process_character(sa, "position right")
    call change_character_name(sa, "My twin sister,")
    "{i}My twin sister, [sa.say_name].{/i}"
    "{i}I don't think we've ever not been together when doing something.{/i}"
    "{i}We share almost all the same interests.\nVideo games, anime...{/i}"
    "{i}And recently we've tried setting up a [video_sharing_site] account.{/i}"
    "{i}It's a place where you can share all kinds of awesome videos.{/i}"
    "{i}And the plan is to upload anime and video game reviews.{/i}"
    "{i}I'm going to start writing some reviews very soon.{/i}"
    "{i}[sa.say_name] also thinks live streaming will help pick up more viewers too.{/i}"
    "{i}She also keeps up to date on technology more than I do.{/i}"
    "{i}She's on the internet constantly.{/i}"
    "{i}But that helps me cause she tells me about everything she's learned.{/i}"

    $ clear_characters()
    $ process_character(n, "position right")
    "{i}We're doing everything we can to keep things stable.{/i}"
    "{i}So we recently just moved to this new home.{/i}"
    "{i}And by recent we still haven't even finished unpacking.{/i}"
    "{i}By the time I move all the boxes I'll be as muscular as [k.say_name]...{/i}"
    "{i}Well, maybe not that muscular.{/i}"
    "{i}But I certainly get a workout from it.{/i}"
    $ renpy.pause(1)
    "{i}I don't know anyone here.{/i}"
    "{i}Except for my Grandma, who lives at a beach house.{/i}"
    "{i}And my Aunt, who recently divorced.{/i}"
    "{i}I only really like talking to my family.{/i}"
    "{i}I get too nervous trying to talk to other people.{/i}"
    "{i}I haven't even gone to the stores down the street.{/i}"
    $ renpy.pause(1)
    "{i}I hope this move will help us.{/i}"
    "{i}We all need to stick together and be happy we have each other.{/i}"
    $ renpy.pause(1)

    call change_character_name(n, "Alright, time for me,")
    
    python:
        last_name = renpy.input("[[Enter a last name]", default = "Williams", length = 14)
           
    call update_last_names

    "Alright, time for me, {color=[n.color]}[n.say_name] [last_name]{/color}, to get up."
    $ stop_music(fadeout=3)
    $ quick_menu = False

    $ clear_characters()
    with Dissolve(0.5)
    show screen intro_title
    with Dissolve(1.0)

    $ renpy.pause(1.5)
    $ play_music("audio/music/Daily_Music_03.ogg", fadein = 2.0, fadeout = 1.0)
    call process_scene_beginning(nate_room, char_tuple_array = [ (n, "outfit underwear pose handsdown face neutral") ])
    $ renpy.scene('screens')
    $ quick_menu = True
    call process_character(n, appearance = "outfit underwear pose handsdown face neutral", text = "{i}Yawn...{/i}")
    call process_character(n, appearance = "outfit underwear pose handsdown face neutral", text = "(That was a pretty good night's sleep)")
    call process_character(n, appearance = "outfit underwear pose handsdown face neutral", text = "(Gotta get used to this room layout)")
    call process_character(n, appearance = "outfit underwear pose handsdown face neutral", text = "(I think my clothes are in this drawer)")
    $ renpy.pause(1)
    call process_character(n, appearance = "outfit underwear pose handsdown face concerned", text = "(No)")
    call process_character(n, appearance = "outfit underwear pose handsdown face concerned", text = "(This one?)")
    $ renpy.pause(1)
    call process_character(n, appearance = "outfit underwear pose twohandfist face happy", text = "(Got it!)")
    call character_leave_dissolve(n)
    $ renpy.pause(1)
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral", text = "(It's great to wake up later than usual).")
    $ renpy.pause(1)
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face concerned", text = "(Feels weird not sharing a room with my sister {color=[sa.color]}[sa.say_name]{/color})")
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral", text = "(I could go see her in her room)")
    call process_character(n, appearance = "outfit clothesjacket pose behindhead face neutral", text = "(Or I could see {color=[k.color]}[k.say_name]{/color}, she may be up and about)")
    call process_character(n, appearance = "outfit clothesjacket pose twohandfist face happy", text = "(I bet {color=[si.color]}Mom{/color} is cooking up a delicious breakfast downstairs)")

    $ scenes_completed.add("intro_0")

    menu:
        "I should go see {color=[sa.color]}[sa.say_name]{/color}.":
            call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral", text = "I wonder how she's doing with the computer setup.")
            call intro_1_chose_sam
        "I'll see what {color=[k.color]}[k.say_name]{/color} is up to.":
            call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral", text = "I think I hear her out in the hallway.")
            call intro_1_chose_kira
        "I'm pretty hungry, I'll go downstairs and greet {color=[si.color]}Mom{/color}.":
            call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral", text = "I think I can smell her awesome omelettes!")
            call intro_1_chose_simone

    return

label intro_1_chose_sam:
    call process_scene_beginning(sam_room, char_tuple_array = [ (n, ""), (sa, "") ])

    call process_character(n, appearance = "pose handpocket face neutral", text = "Hey.")
    call process_character(sa, appearance = "pose leaning face neutral")
    $ sa.c_full("Oh hey [n.say_name]!")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Just wanted to see how you were doing.")
    call process_character(sa, appearance = "pose handface face neutral", text = "Aw, thanks for checking on me.")
    call process_character(sa, appearance = "pose handface face neutral", text = "We shared a room for all our lives, and now we each have our own.")
    call process_character(sa, appearance = "pose handface face neutral", text = "At least we are right next to each other.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "That's true.")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "I was up late last night setting up all the computer gear.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Oh?")
    call process_character(n, appearance = "pose handfist face neutral", text = "Can we stream yet?")
    call process_character(sa, appearance = "pose handface face happy", text = "Almost!")
    call process_character(sa, appearance = "pose handface face happy", text = "Can't waste any time when trying to build a following.")
    call process_character(sa, appearance = "pose leaning face neutral", text = "The stream will be up and running tomorrow.")
    call process_character(sa, appearance = "pose handface face neutral", text = "You gonna join me with some game streaming?")

    menu:
        "Yeah, sure.":
            $ sa.add_points(1, tag = "intro_1_chose_sam_join_streaming")
            call process_character(sa, appearance = "pose leaning face happy", text = "Aww yeah!\nOur stream channel is a go!")
        "Maybe, we'll see.":
            call process_character(n, appearance = "pose handpocket face neutral")
            call process_character(sa, appearance = "pose handsbehind face neutral", text = "Well, hopefully you can hop in when you get a chance.")

    call process_character(sa, appearance = "pose handface face neutral", text = "Well Mom is probably waiting for us downstairs.")
    call process_character(sa, appearance = "pose handface face neutral", text = "Hope she's making omelettes!")
    call process_character(sa, appearance = "pose handface face happy", text = "Let's move before [k.say_name] gobbles them all down!")

    $ scenes_completed.add("intro_1_chose_sam")
    call intro_2
    return

label intro_1_chose_kira:
    call process_scene_beginning(hallway, char_tuple_array = [ (n, ""), (k, "pose armcross") ])

    call process_character(k, appearance = "pose armcross face neutral")
    $ k.c_full("Hey bro.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Hey [k.say_name].")
    call process_character(k, appearance = "pose armcross face neutral", text = "Still sore from moving those boxes yesterday?")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Not too bad.\nBut I was really tired last night.")
    call process_character(k, appearance = "pose handhip face neutral", text = "I'll bet.")
    call process_character(k, appearance = "pose handhip face happy", text = "You were sweating bullets!")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Hey, is the bathroom available?")
    call process_character(k, appearance = "pose armcross face neutral", text = "Just got out after a jog.")
    call process_character(n, appearance = "pose handpocket face curious", text = "Last time I was in the shower after you, the drain was clogged.")
    call process_character(k, appearance = "pose armcross face happy", text = "Oh yeah, haha.\nWell, it shouldn't be this time.")
    call process_character(k, appearance = "pose armcross face neutral")
    call process_character(n, appearance = "pose handpocket face curious", text = "It looked like your hair in the drain.\nYour hair isn't falling out is it?")
    call process_character(k, appearance = "pose handhip face neutral", text = "No, it wasn't the hair on my head.\nI was shaving.")
    call process_character(n, appearance = "pose behindhead face curious")
    $ renpy.pause(1)
    call process_character(n, appearance = "pose behindhead face curious", text = "Shaving what?")
    call process_character(k, appearance = "pose armsup face neutral", text = "Just keeping the runway clean.")
    call process_character(n, appearance = "pose handpocket face curious")
    $ renpy.pause(1)
    call process_character(n, appearance = "pose handpocket face curious", text = "{i}?{/i}")
    call process_character(k, appearance = "pose armsup face neutral", text = "(Went right over his head)")
    $ renpy.pause(1)
    call process_character(k, appearance = "pose armsup face neutral", text = "Hey!")
    call process_character(k, appearance = "pose handhip face neutral")
    call process_character(n, appearance = "pose handpocket face neutral")
    call process_character(k, appearance = "pose handhip face neutral", text = "I'm going to be doing an exercise challenge tomorrow.")
    call process_character(k, appearance = "pose handhip face neutral", text = "And I need your help with it.")
    call process_character(k, appearance = "pose handhip face neutral", text = "You down?")

    menu:
        "Sure!":
            $ k.add_points(1, tag = "intro_1_chose_kira_you_down")
            call process_character(n, appearance = "pose twohandfist face neutral")
            call process_character(k, appearance = "pose armsup face happy", text = "Sweet!")
        "Down for what?":
            call process_character(n, appearance = "pose handpocket face curious")
            call process_character(k, appearance = "pose handhip face concerned", text = "{i}Sigh{/i}\nJust come see me tomorrow, and I'll explain it.")
            
    call process_character(n, appearance = "pose handpocket face neutral")
    call process_character(k, appearance = "pose armcross face neutral", text = "I'm smelling a strong concoction of ingredients in Mom's omelettes.")
    call process_character(k, appearance = "pose armcross face neutral", text = "She must be trying one of those new recipes I showed her.")
    call process_character(k, appearance = "pose handhip face neutral", text = "See you down there!")

    $ scenes_completed.add("intro_1_chose_kira")
    call intro_2

    return

label intro_1_chose_simone:
    call process_scene_beginning(kitchen, char_tuple_array = [ (n, ""), (si, "") ])

    call process_character(n, appearance = "pose handpocket face neutral", text = "Hi Mom!")
    call process_character(si, appearance = "pose handsfront face neutral")
    $ si.c_full("Good morning [n.say_name]!\nI just finished cooking.")
    call process_character(n, appearance = "pose twohandfist face happy", text = "Awesome.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "It's first come, first serve.")
    call process_character(si, appearance = "pose armunder face happy", text = "And it looks like you're first in line!")
    call process_character(n, appearance = "pose handpocket face neutral", text = "What do you have?")
    call process_character(si, appearance = "pose handsup face neutral", text = "I got some egg white omelettes, with fresh spinach and tomato.")
    call process_character(si, appearance = "pose handsup face neutral", text = "Some rye bread from the bakery,")
    call process_character(si, appearance = "pose handsup face neutral", text = "Milk and orange juice.")
    call process_character(si, appearance = "pose handsup face happy", text = "Take your pick!")

    menu:
        "Thanks Mom!":
            call process_character(si, appearance = "pose handsfront face neutral", text = "You're welcome!")
        "Want me to help clean the dishes after?":
            $ si.add_points(1, tag = "intro_1_chose_simon_take_pick")
            call process_character(si, appearance = "pose armunder face neutral", text = "That's so sweet of you [n.say_name]! Thank you!")

    $ scenes_completed.add("intro_1_chose_simone")
    call intro_2

    return

label intro_2:
    $ temp_variable = True
    python:
        if "intro_1_chose_simone" in scenes_completed:
            temp_variable = False

    if temp_variable:
        call process_scene_beginning(kitchen)
    else:
        call character_leave_dissolve(si)
        

    call process_character(n, appearance = "position right", show_bust = False)
    call process_character(k, appearance = "position right", show_bust = False)
    call process_character(sa, appearance = "position right", show_bust = False)
    call process_character(si, appearance = "position right", show_bust = False)

    call process_character(n, appearance = "pose twohandfist face neutral", text = "This breakfast is so great!", replace = True)
    call process_character(si, appearance = "pose handsfront face neutral", replace = True)

    python:
        if "intro_1_chose_simone" in scenes_completed:
            si.c("Glad you like it!\n[k.say_name] suggested the recipe.")
        else:
            si.c_full("Glad you like it!\n[k.say_name] suggested the recipe.")

    call process_character(k, appearance = "pose armcross face neutral", replace = True)

    python:
        if "intro_1_chose_kira" in scenes_completed:
            k.c("It gives a lot of nutrition.")
        else:
            k.c_full("It gives a lot of nutrition.")

    call process_character(k, appearance = "pose armsup face neutral", text = "Which I need to keep these guns loaded.", replace = True)
    call process_character(n, appearance = "pose handpocket face curious", text = "We don't have any guns in the house?", replace = True)
    $ process_character_replace_utility(si, appearance = "pose armunder face happy", text = "Haha, it's just an expression [n.say_name]!", replace = True)

    call process_character(sa, appearance = "pose leaning face neutral", replace = True)

    python:
        if "intro_1_chose_sam" in scenes_completed:
            sa.c("Mom!\nIs the pool ready yet?")
        else:
            sa.c_full("Mom!\nIs the pool ready yet?")

    call process_character(si, appearance = "pose handsfront face neutral", text = "Almost sweety.\nI've scheduled a technician to stop by to fix the pump.", replace = True)
    call process_character(sa, appearance = "pose handsbehind face happy", text = "Yess!", replace = True)
    $ process_character_replace_utility(sa, appearance = "pose handsbehind face neutral", text = "[n.say_name], we should see who can swim from one end of the pool to the other without taking a breath!", replace = True)
    call process_character(n, appearance = "pose behindhead face curious", text = "Well uh...", replace = True)
    $ process_character_replace_utility(k, appearance = "pose handhip face neutral", text = "Gotta work on increasing your lung capacity [n.say_name]!", replace = True)
    call process_character(k, appearance = "pose armcross face neutral", text = "You don't want to get beat by a girl do you?", replace = True)
    call process_character(n, appearance = "pose handpocket face concerned", text = "What do you mean?{p=1.0}You've beaten every boy you've swam against.", replace = True)
    call process_character(k, appearance = "pose handhip face happy", text = "I'm just teasing.", replace = True)
    call process_character(k, appearance = "pose armsup face neutral", text = "But seriously I can't wait for that pool to be up and running.", replace = True)
    call process_character(k, appearance = "pose armsup face neutral", text = "The climate here is a lot warmer.", replace = True)
    call process_character(si, appearance = "pose handsup face neutral", text = "Now that we live close to Grandma, we'll have to see if we can visit her at the beach some time!", replace = True)
    $ renpy.pause(1)
    call process_character(si, appearance = "pose handsfront face neutral", text = "So what's everyone's plan for the day?", replace = True)
    call process_character(k, appearance = "pose handhip face concerned", text = "I gotta head out to work.", replace = True)
    call process_character(k, appearance = "pose handhip face neutral", text = "But I'm looking forward to some cardio training!", replace = True)
    call process_character(sa, appearance = "pose handface face curious", text = "Since the pool's not up yet...", replace = True)
    call process_character(sa, appearance = "pose handface face neutral", text = "I'll play some video games!", replace = True)
    $ process_character_replace_utility(si, appearance = "pose handsfront face neutral", text = "What's your plan [n.say_name]?", replace = True)

    $ scenes_completed.add("intro_2")

    menu:
        "I'll relax outside in the sun.":
            call process_character(si, appearance = "pose handsfront face neutral", text = "Remember to put sunscreen on!", replace = True)
            call intro_3_chose_kira
        "I'll play some video games with {color=[sa.color]}[sa.say_name]{/color}!":
            $ sa.add_points(1, tag = "intro_2_what_plan")
            call process_character(sa, appearance = "pose leaning face happy", text = "All right! Co-op mode!", replace = True)
            call intro_3_chose_sam
        "I'll move some more storage boxes with you {color=[si.color]}Mom{/color}.":
            $ si.add_points(2, tag = "intro_2_what_plan")
            call process_character(si, appearance = "pose handsup face happy", text = "Thank you [n.say_name]!", replace = True)
            call process_character(si, appearance = "pose handsup face happy", text = "I could use some help with it!", replace = True)
            call intro_3_chose_simone

    return

label intro_3_chose_sam:
    call process_scene_beginning(sam_room, char_tuple_array = [ (n, ""), (sa, "") ])

    call process_character(sa, appearance = "pose handface face neutral", text = "This game got so many good reviews.")
    call process_character(sa, appearance = "pose handface face neutral", text = "I watched GameGrinch play through the first hour.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "\"Soultwister.\"")
    call process_character(sa, appearance = "pose leaning face neutral", text = "Yeah, it's a shmup.")
    call process_character(n, appearance = "pose handpocket face curious", text = "A shmup?")
    call process_character(sa, appearance = "pose handface face neutral", text = "Oh uh, it's a term online they use to describe those top down shooter games.")
    call process_character(sa, appearance = "pose handface face neutral", text = "\"Shoot-em-up.\"")
    call process_character(sa, appearance = "pose handface face happy", text = "\"Shmup.\"")
    call process_character(n, appearance = "pose handpocket face happy", text = "Ooh, I see.")
    call process_character(n, appearance = "pose handfist face happy", text = "So how does co-op mode work?")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "So it's really cool.")
    call process_character(n, appearance = "pose handpocket face neutral")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "We both control one ship.")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "One person controls the ship's movement.\nThe other uses the weapons.")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "So we have to coordinate our attacks.")
    call process_character(n, appearance = "pose handpocket face happy", text = "That sounds pretty cool.")
    call process_character(sa, appearance = "pose leaning face neutral", text = "Did you want to control movement or weapons?")

    menu:
        "I'll handle the movement.":
            call process_character(n, appearance = "pose twohandfist face neutral")
            call process_character(sa, appearance = "pose leaning face neutral", text = "I'll blast the enemies with my laser weapons!")
        "I'll handle the weapons.":
            call process_character(n, appearance = "pose twohandfist face neutral")
            call process_character(sa, appearance = "pose handface face curious", text = "Time to show off my dodging skills!")
        "You can pick instead.":
            call process_character(n, appearance = "pose behindhead face neutral")
            $ sa.add_points(1, tag = "intro_3_chose_sam_controls")
            call process_character(sa, appearance = "pose handsbehind face neutral blush true", text = "Aw, thanks!")
            call process_character(sa, appearance = "pose handsbehind face happy blush false", text = "Alright, I'll choose random!")

    call process_character(n, appearance = "pose handpocket face neutral")
    call process_character(sa, appearance = "pose leaning face neutral", text = "Okay, almost ready.")
    call process_character(sa, appearance = "pose leaning face neutral", text = "I think we'll go with normal difficulty for now.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "How many achievements are in this game?")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "Oh an insane amount!\nYou can unlock like, I think 40 different weapons.")
    call process_character(sa, appearance = "pose handsbehind face neutral", text = "It's crazy.")
    call process_character(n, appearance = "pose twohandfist face happy", text = "Well, might as well start unlocking them!")
    call process_character(sa, appearance = "pose handface face neutral", text = "I know Eric on GameGrinch found a secret weapon on the first level.")
    call process_character(sa, appearance = "pose handface face curious", text = "I think I remember where it is.{p=1.0}We have to blow up a rock blocking a cave.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "Just let me know when you see it.")
    call process_character(sa, appearance = "pose leaning face neutral", text = "You got it.")
    call process_character(sa, appearance = "pose leaning face happy", text = "And game is launched!")

    $ scenes_completed.add("intro_3_chose_sam")
    call intro_4

    return

label intro_3_chose_simone:
    call process_scene_beginning(living_room, char_tuple_array = [ (n, ""), (si, "pose handsfront") ])

    call process_character(si, appearance = "pose handsfront face neutral", text = "I really appreciate your help [n.say_name].")
    call process_character(si, appearance = "pose handsfront face neutral", text = "Don't strain yourself though.")
    call process_character(n, appearance = "pose handpocket face neutral", text = "That's okay Mom.")
    call process_character(n, appearance = "pose behindhead face neutral", text = "We still have a lot to move.")
    call process_character(si, appearance = "pose armunder face neutral", text = "I know.")
    call process_character(si, appearance = "pose armunder face happy", text = "I didn't realize how much stuff we packed.")
    call process_character(n, appearance = "pose handpocket face curious", text = "I wonder how much of it we could have thrown out from the other house.")
    call process_character(si, appearance = "pose handsfront face curious", text = "I feel like we already threw out a lot of things from the old home.")
    $ renpy.pause(1)
    call process_character(n, appearance = "pose handpocket face concerned")

    menu:
        "Do you miss our old home Mom?":
            call process_character(si, appearance = "pose handsup face flirty", text = "As long as I have you and your sisters, it doesn't matter which home I'm in.")
        "Mom, how have you been feeling?":
            call process_character(si, appearance = "pose handsfront face neutral", text = "Thank you [n.say_name] for asking.")
            call process_character(si, appearance = "pose handsfront face neutral", text = "I have been feeling okay.")

    call process_character(si, appearance = "pose handsup face neutral", text = "Sometimes it does get tough for me.")
    call process_character(si, appearance = "pose handsup face neutral", text = "It's easy to get stuck dwelling on everything that has happened.")
    call process_character(si, appearance = "pose armunder face happy", text = "But when I see you or [sa.say_name] having fun, I'm able to feel much better!")
    call process_character(n, appearance = "pose handpocket face neutral", text = "I just wanted to make sure you had someone to talk to, if need be.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "Well that is very sweet of you [n.say_name].")
    call process_character(si, appearance = "pose handsup face flirty", text = "I'm very blessed to have a selfless son.\nAnd a supportive family.")
    call process_character(n, appearance = "pose behindhead face curious", text = "Though for some reason the support isn't here for moving these boxes today.")
    call process_character(si, appearance = "pose handsup face happy", text = "Haha, well...")
    call process_character(si, appearance = "pose handsfront face neutral", text = "It's not like all these boxes have to be moved in one day.")
    call process_character(n, appearance = "pose handpocket face neutral")
    call process_character(si, appearance = "pose handsfront face neutral", text = "We'll just keep picking away at it.")
    call process_character(si, appearance = "pose handsfront face neutral", text = "I think we've moved enough for today.")
    call process_character(n, appearance = "pose handfist face neutral", text = "My arms were getting a good workout.")
    call process_character(n, appearance = "pose handpocket face neutral")
    call process_character(si, appearance = "pose handsup face neutral", text = "Did you want me to make you some iced tea?")
    call process_character(si, appearance = "pose handsup face happy", text = "Sweetened, of course.")
    call process_character(n, appearance = "pose twohandfist face neutral", text = "Sure!{p=1.0}Thanks Mom.")

    $ scenes_completed.add("intro_3_chose_simone")
    call intro_4

    return

label intro_3_chose_kira:
    call process_scene_beginning(backyard, char_tuple_array = [ (n, "pose behindhead face happy outfit swimsuit") ])

    call process_character(n, appearance = "pose behindhead face happy outfit swimsuit", text = "{i}Ahh{/i}{p=1.0}Feels good out here!")
    call process_character(n, appearance = "pose behindhead face embarrassed", text = "(Though I'd better be careful not to burn myself){p=1.0}(This location has a much hotter sun)")
    call process_character(k, appearance = "pose armcross face neutral", text = "Vegging out today eh?")
    call process_character(n, appearance = "pose handsdown face happy", text = "Oh hey!")
    call process_character(n, appearance = "pose handsdown face happy", text = "Did you just get back from work?")
    call process_character(k, appearance = "pose handhip face neutral", text = "Oh yeah...")
    call process_character(n, appearance = "pose behindhead face concerned", text = "Tough day?")
    call process_character(k, appearance = "pose armcross face neutral", text = "Tough for the people I'm training!")
    call process_character(k, appearance = "pose armcross face concerned", text = "Some couldn't even complete 5 push-ups!{p=1.0}And that was after I motivated them!")
    call process_character(n, appearance = "pose handsdown face neutral", text = "Are you liking it so far?")
    call process_character(k, appearance = "pose armsup face neutral", text = "Oh definitely!")
    call process_character(k, appearance = "pose armsup face happy", text = "I get to work out, and get paid while doing it!")
    call process_character(n, appearance = "pose handsdown face neutral", text = "You gonna lay out in the sun too?")
    call process_character(k, appearance = "pose handhip face neutral", text = "Eh, maybe.{p=1.0}I've been out in the sun a lot lately.")
    call process_character(k, appearance = "pose handhip face neutral", text = "It's really easy to build up a tan in this climate.")
    call process_character(n, appearance = "pose twohandfist face neutral", text = "I'll say!{p=1.0}You're already very tan!")
    call process_character(k, appearance = "pose armsup face neutral", text = "Bronze goddess I am! Hehe.")
    $ k.add_points(1, tag = "intro_3_chose_kira_bronze")
    call process_character(k, appearance = "pose handhip face curious", text = "Has the pool repair guy stopped by yet?")
    call process_character(n, appearance = "pose behindhead face neutral", text = "I haven't seen anyone.")
    call process_character(k, appearance = "pose armcross face concerned", text = "{i}Sigh{/i}{p=1.0}Probably flaked out and forgot to come by again.")
    call process_character(k, appearance = "pose armcross face concerned", text = "I really want the hot tub to get working again.")
    call process_character(n, appearance = "pose twohandfist face neutral", text = "Yeah!")
    call process_character(n, appearance = "pose twohandfist face neutral", text = "Could be nice to use on cooler nights.")
    call process_character(k, appearance = "pose handhip face neutral", text = "Well in the meantime...")
    call process_character(n, appearance = "pose handsdown face neutral")
    call process_character(k, appearance = "pose handhip face neutral", text = "I've been looking to buy a new bikini.")
    call process_character(k, appearance = "pose handhip face neutral", text = "I may have found one online.")
    call process_character(k, appearance = "pose handhip face neutral", text = "It's green in color.")

    menu:
        "I can't wait to see it!":
            $ k.add_points(1, tag = "intro_3_chose_kira_green_bikini")
            call process_character(n, appearance = "pose handfist face happy")
            call process_character(k, appearance = "pose armcross face flirty", text = "(I'll bet you can't)")
        "I think yellow would look good too.":
            call process_character(n, appearance = "pose handsdown face neutral")
            call process_character(k, appearance = "pose armcross face concerned", text = "Eh...")
            call process_character(k, appearance = "pose armcross face concerned", text = "Yellow's a bit neutral for me.")
            call process_character(k, appearance = "pose armcross face concerned", text = "Maybe if it was bright yellow.")

    call process_character(n, appearance = "pose handsdown face neutral")
    call process_character(k, appearance = "pose handhip face neutral", text = "I think dinner will be ready in a bit.")
    call process_character(k, appearance = "pose handhip face neutral", text = "I'll see you inside.")
    call process_character(n, text = "Okay.")

    $ scenes_completed.add("intro_3_chose_kira")
    call intro_4

    return

label intro_4:
    $ stop_music(fadeout=3)
    $ week.time = "night"
    call process_scene_beginning(nate_room)

    $ temp_variable = "kira"
    python:
        if "intro_3_chose_sam" in scenes_completed:
            temp_variable = "sam"
        if "intro_3_chose_simone" in scenes_completed:
            temp_variable = "simone"

    if temp_variable == "kira":
        call process_character(n, appearance = "pose behindhead face happy", text = "{i}Ah!{/i}\nWhat an easy going day!")
    if temp_variable == "sam":
        call process_character(n, appearance = "pose twohandfist face happy", text = "That game was a ton of fun.")
        call process_character(n, appearance = "pose handpocket face concerned", text = "We couldn't beat the final boss though.")
    if temp_variable == "simone":
        call process_character(n, appearance = "pose behindhead face flirty", text = "{i}Whew!{/i}\nWow am I tired from moving those boxes!")

    call process_character(n, appearance = "pose handpocket face neutral", text = "I don't think I'm quite ready for bed just yet.")
    call process_character(n, appearance = "", text = "Maybe I could see what everyone else is doing.")

    call character_leave_dissolve(n)

    "Each day you'll have the opportunity to explore and interact with characters."
    "Part of this interaction includes mini-games, which are the primary method of building relationships."
    "There are also unique events that can increase relationship with a character."
    "As your relationship grows, special scenes will become available for that character!"
    "Each relationship level unlocks a new scene."
    "You are free to choose who you want to have relationships with!"
    "Some situations will require \"Boldness.\""
    "Boldness is an important attribute to accumulate."
    "Boldness can be increased through certain scenes and mini-games."
    "Try to discover these scenes and mini-games!"
    "As you level up your Boldness, you'll have the potential to perform new actions, or explore new locations."

    $ nate_room.decide_and_play_daily_music_queue()
    $ stats.current_zone = home

    call day_reset_locations_chars
    call navigation_menu
     
    return

label julia_pre_arrival:
    call process_scene_beginning(bg = "bg kitchen_daytime")
    $ nate_room.decide_and_play_daily_music_queue()

    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false position right", text = "We'll be hosting a visitor to our home!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose leaning face neutral blush false position right", text = "Oh yeah?", replace = True)
    call process_character(sa, appearance = "outfit clothes pose leaning face neutral blush false", text = "Who?", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "It's your cousin, [julia.say_name].", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral blush false", text = "We haven't seen her in a long time.", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "Oh man!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "She was a blast to hang around with!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "We'd make these huge water balloon arsenals.", replace = True)
    call process_character(sa, appearance = "outfit clothes pose leaning face happy blush false", text = "And gang up on [n.say_name]!", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face curious blush false", text = "...", replace = True)
    call process_character(sa, appearance = "outfit clothes pose leaning face neutral blush false", text = "When's she arriving?", replace = True)
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "Tomorrow, apparently.", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "That soon?", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face happy blush false", text = "Sweet!", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "Yes, well your Aunt tends to schedule on the fly...", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face concerned blush false", text = "And she only told me [julia.say_name] was stopping by this morning.", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face concerned blush false", text = "...", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "Thankfully, we do have accommodations for her!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handsbehind face neutral blush false", text = "She can stay in my room!", replace = True)
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "I don't know if she'll want to sleep on the floor dear!", replace = True)
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "The couch in the living room is comfortable.", replace = True)
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "She can sleep there.", replace = True)
    call process_character(k, appearance = "pose armsup face neutral blush false position right", text = "Who's staying over now?", replace = True)
    call process_character(sa, appearance = "outfit clothes pose leaning face neutral blush false", text = "Our cousin [julia.say_name] is stopping by tomorrow!", replace = True)
    call process_character(k, appearance = "outfit clothes pose armcross face neutral blush false", text = "Really?", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "I can't wait to do all the stuff we did last time!", replace = True)
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "That was a while ago [sa.say_name].", replace = True)
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "She might be into different things now.", replace = True)
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "Last I heard, she was trying to be a writer.", replace = True)
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "Oh, she's a writer?", replace = True)
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "I think she just does it for fun.", replace = True)
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "I've read some of her stuff online.", replace = True)
    call process_character(k, appearance = "pose armcross face neutral blush false", text = "It's not half bad.", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "Good for her!", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "She's tapping into her creativity.", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "Maybe she and I can write a story together!", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "You'll have to ask her when she arrives tomorrow sweetie.", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose behindhead face neutral blush false", text = "How long is she staying?", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "She'll actually be here the entire summer!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "{i}Gasp{/i}...", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "The entire summer?!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face happy blush false", text = "Yes!", replace = True)
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "I figured you'd be happy to hear that!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "There's so much we can do!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handsbehind face neutral blush false", text = "I gotta see what video games she may want to play!", replace = True)
    call process_character(sa, appearance = "outfit clothes pose handsbehind face happy blush false", text = "We could have a gaming marathon all summer long!", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral blush false", text = "Maybe she'll want to check out the pool while she's over.", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "[julia.say_name]'s more than welcome to use it!", replace = True)
    call process_character(k, appearance = "pose armcross face neutral blush false", text = "You and [sa.say_name] should show her your stream thing.", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "Oh yes!", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "I think she'd really enjoy that!", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose handfist face neutral blush false", text = "That might be cool, yeah.", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "Why don't you talk to [sa.say_name] about it?", replace = True)
    call process_character(si, appearance = "outfit clothes pose handsfront face happy blush false", text = "I'm sure she'd be up for it!", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose twohandfist face happy blush false", text = "[julia.say_name] could be like a special guest on our stream!", replace = True)
    call process_character(n, appearance = "outfit clothesjacket pose twohandfist face happy blush false", text = "I'll go tell [sa.say_name] right now!", replace = True)

    call character_leave_dissolve(n)
    pause 0.5

    $ display_multiple_characters([ (si, "pose handsfront face neutral blush false position right"), (k, "pose armcross face neutral blush false position left") ])

    call process_character(k, appearance = "pose armcross face neutral blush false", text = "...")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "...")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "The entire summer she'll be here?")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "Wow.")
    call process_character(si, appearance = "pose handsup face happy blush false", text = "It will be a busy household, that's for sure!")
    call process_character(k, appearance = "pose handhip face happy blush false", text = "Good thing our house is large enough to handle a guest for an extended stay.")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "It will be nice to see how [julia.say_name] has been doing.")
    call process_character(k, appearance = "pose armcross face neutral blush false", text = "We'll get to see her soon enough.")

    $ reset_all_characters()
    if started_main_game:
        $ had_julia_pre_arrival_scene = True
        show screen hud
        $ advance_time_return_location.start(force_music_change = True, morning_wake_lines = False)
    else:
        jump debug_menu

    return

label julia_arrival:
    $ nate_room.decide_and_play_daily_music_queue()
    call process_scene_beginning(bg = "bg hallway_daytime")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "...")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "(I wonder if [julia.say_name] has arrived yet...)")
    call process_character(si, text = "[n.say_name]!")
    call process_character(si, text = "Come on downstairs!")

    call process_new_location(bg = living_room)

    call process_character(si, appearance = "pose handsup face neutral blush false position right", text = "[julia.say_name] is here!")
    call character_leave_dissolve(si)
    pause 0.5

    call process_character(julia, appearance = "pose handface face neutral blush false", show_bust = False)
    $ refresh_character(julia, force_transition = Dissolve(0.75))
    pause 0.75

    call process_character(n, appearance = "pose handpocket face happy blush false position right", text = "Hey [julia.say_name]!")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "...")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "Hey.")
    call character_leave_dissolve(n)
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "So you'll have the couch to sleep on while you stay here [julia.say_name].")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "I've provided some pillows and blankets for you.")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "...")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "I actually have to head out.")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "[n.say_name], why don't you show [julia.say_name] around the house?")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "Help her get familiar with things.")
    call character_leave_dissolve(si)
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "Okay Mom!")
    call character_leave_dissolve(n)
    call process_character(si, appearance = "pose handsup face happy blush false", text = "I'll see you two later!")

    $ clear_characters()

    $ display_multiple_characters([ (julia, "pose handface face neutral blush false"), (n, "pose handpocket face neutral blush false position right") ])

    call process_character(julia, appearance = "pose handface face neutral blush false", text = "...")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "...")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "Okay, so let me give you a tour!")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "...")

    call process_new_location(bg = kitchen, char_tuple_array = [ (n, "outfit clothesjacket pose handpocket face neutral blush false"), (julia, "outfit clothes pose handup face neutral blush false")] )

    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "So here's the kitchen!")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "There's plenty of snacks in the cabinets.")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "...")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "My Mom grows and stores a lot of vegetables for us.")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "I'm personally more of a fan of fruits.")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "...")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "I  keep some of my favorite cereals in the back.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "If [k.say_name] finds them, she'll eat all of it.")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "...")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "Shouldn't she buy her own cereal to eat?")
    call process_character(n, appearance = "pose behindhead face curious blush false", text = "...")
    call process_character(n, appearance = "pose behindhead face curious blush false", text = "That's a good point...")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "Well, we buy cereal frequently.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "So usually there's some available.")

    call process_new_location(bg = backyard, char_tuple_array = [(julia, "pose handface face neutral blush false"), (n, "pose twohandfist face neutral blush false")] )

    call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "Now this...")
    call process_character(n, appearance = "pose twohandfist face happy blush false", text = "This is the best part of the house in my opinion!")
    call process_character(n, appearance = "pose twohandfist face happy blush false", text = "We got a big pool we can swim in all the time.")
    call process_character(n, appearance = "pose twohandfist face happy blush false", text = "Provided it's warm enough outside.")
    call process_character(n, appearance = "pose handfist face happy blush false", text = "So you could be out here the whole day practically!")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "I burn easily.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "We got plenty of sunscreen on hand.")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "My Mom always tells me to put it on.")
    call process_character(n, appearance = "pose behindhead face happy blush false", text = "I haven't gotten burned yet!")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "...")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "Alright, let's go back inside, and I'll show you the rest of the house.")


    call process_new_location(bg = hallway, char_tuple_array = [(julia, "pose armcross face neutral blush false"), (n, "pose handpocket face neutral blush false")] )

    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "Up here is where my room is, along with [sa.say_name] and...")
    call character_leave_dissolve(n)
    call process_character(k, appearance = "outfit clothes pose armcross face neutral blush false position right", text = "Sup [n.say_name].")
    call process_character(k, appearance = "pose armsup face neutral blush false", text = "Oh hey [julia.say_name]!")
    call process_character(k, appearance = "pose armsup face neutral blush false", text = "Did you just get here?")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "Yeah.")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "[n.say_name]'s showing you around I take it?")
    call character_leave_dissolve(k)
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "Yep!")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "I'm giving her the tour of the house.")
    call character_leave_dissolve(n)
    call process_character(k, appearance = "pose armcross face neutral blush false", text = "What do you think so far [julia.say_name]?")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "...")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "It's nice.")
    call process_character(k, appearance = "pose armsup face neutral blush false", text = "You should check out our bathroom when you get a chance.")
    call process_character(k, appearance = "pose armsup face neutral blush false", text = "It's got all the bells and whistles you can think of!")
    call character_leave_dissolve(k)
    call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "Yeah!")
    call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "I like using it.")

    if "simone_scene_1_seq_1" in scenes_completed:
        call character_leave_dissolve(n)
        call process_character(k, appearance = "blush false", text = "[n.say_name] likes spending extra time in there.")
        call process_character(k, appearance = "pose armcross face happy blush false", text = "It's why we need a lot of tissue paper.")
        call character_leave_dissolve(k)
        call process_character(n, appearance = "pose behindhead face embarrassed blush false", text = "...")

    call process_character(julia, appearance = "pose handface face neutral blush false", text = "...")
    call character_leave_dissolve(n)
    call process_character(k, appearance = "pose armsup face neutral blush false", text = "I'll let [n.say_name] finish showing you around the house.")
    call process_character(k, appearance = "pose armsup face neutral blush false", text = "I have to clean up after my cardio routine.")
    call character_leave_dissolve(k)
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "[k.say_name] does a lot of exercises.")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "That's why she's in really good shape.")
    call character_leave_dissolve(n)
    call process_character(k, appearance = "pose armsup face happy blush false", text = "These muscles won't build themselves!")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "...")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "Anyway, I'll chat with you two later.")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "See ya.")
    call character_leave_dissolve(k)
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "Alright, it's on to my room!")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "...")

    call process_new_location(bg = nate_room, char_tuple_array = [(julia, "pose handface face neutral blush false"), (n, "pose handfist face happy blush false")] )

    call process_character(julia, appearance = "pose handface face neutral blush false")
    call process_character(n, appearance = "pose handfist face happy blush false", text = "And here it is!")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "Before this house, [sa.say_name] and I shared a room.")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "Yeah, I remember.")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "I usually hang out in [sa.say_name]'s room a lot to be honest.")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "All the video games are in there.")
    call process_character(n, appearance = "pose behindhead face happy blush false", text = "Oh!")
    call process_character(n, appearance = "pose behindhead face happy blush false", text = "Speaking of which!")
    call process_character(n, appearance = "pose twohandfist face happy blush false", text = "[sa.say_name] and I have our own streaming channel!")
    call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "And we also review video games and shows.")
    call process_character(julia, appearance = "pose handface face happy blush false", text = "That's cool.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "We were thinking you could join us as a guest on our next stream!")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "[sa.say_name] and I went through our game collection...")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "{cps=40}And we found some great choices so all of us could-{/cps}{w=0.75}{nw}")

    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "I'm not really into video games.")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "...")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "Oh...")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "And I'd rather not appear on a stream.")
    call process_character(n, appearance = "pose behindhead face curious blush false", text = "...")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "That's okay.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "{cps=40}You can always watch us when we're live to see how it-{/cps}{w=0.75}{nw}")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "I'm good.")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "...")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "Thanks for showing me around the house.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "No problem!")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "...")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "So what would you like to do then?")
    call process_character(n, appearance = "pose twohandfist face happy blush false", text = "[sa.say_name] and I have the whole day free!")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "Actually, I was just gonna go downstairs and read for a while.")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "Oh...")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "Alright.")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "You gonna read some comic books?")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "No, I'm reading a novel.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "Oh yeah?")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "We could take turns narrating it!")
    call process_character(julia, appearance = "pose handface face curious blush false", text = "I think that would take a while.")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "Can't be too bad.")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "How long is the novel?")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "Six hundred pages.")
    call process_character(n, appearance = "pose behindhead face embarrassed blush false", text = "Six hundred pages?!")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "Yeah.")
    call process_character(n, appearance = "pose handpocket face embarrassed blush false", text = "That would take me forever to read!")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "It's not that bad.")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "I'll probably complete it in a couple days.")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "...{p}...")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "Anyway, I'll be downstairs.")
    call process_character(n, appearance = "pose twohandfist face concerned blush false", text = "Wait!")
    call process_character(n, appearance = "pose behindhead face concerned blush false", text = "Don't you want to say hi to [sa.say_name]?")
    call process_character(n, appearance = "pose behindhead face concerned blush false", text = "She's right in her room.")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "I don't want to disturb her.")
    call process_character(n, appearance = "pose handfist face neutral blush false", text = "{cps=40}Oh it's fine, she's actually been waiting for-{/cps}{w=0.75}{nw}")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "I'll see her soon enough.")
    call process_character(julia, appearance = "pose armcross face neutral blush false", text = "You can tell her I'm in the living room..")

    call character_leave_dissolve(julia)
    pause 0.5

    call process_character(n, appearance = "pose handpocket face concerned blush false", text = "...{p}...")
    call process_character(n, appearance = "pose behindhead face concerned blush false", text = "(Guess I gotta tell [sa.say_name] [julia.say_name] won't be joining us...)")

    call process_new_location(bg = sam_room, char_tuple_array = [(sa, "outfit clothes pose handface face embarrassed blush false"), (n, "pose behindhead face concerned blush false")] )

    call process_character(n, appearance = "pose behindhead face concerned blush false")

    call process_character(sa, appearance = "outfit clothes pose handface face embarrassed blush false", text = "She's not going on the stream?!")
    call process_character(n, appearance = "pose behindhead face concerned blush false", text = "No.")
    call process_character(n, appearance = "pose handpocket face concerned blush false", text = "She said she doesn't like video games that much.")
    call process_character(sa, appearance = "outfit clothes pose handsbehind face concerned blush false", text = "Aw man, and we had everything planned out!")
    call process_character(n, appearance = "pose handpocket face concerned blush false", text = "Yeah, it's too bad.")

    call process_character(sa, appearance = "pose handface face concerned blush false", text = "...{p}...")
    call process_character(sa, appearance = "pose handface face concerned blush false", text = "So she's not into video games at all huh?")
    call process_character(sa, appearance = "pose handface face concerned blush false", text = "What does she like?")
    call process_character(sa, appearance = "pose handface face concerned blush false", text = "Did she tell you?")
    call process_character(n, appearance = "pose behindhead face curious blush false", text = "...")
    call process_character(n, appearance = "pose behindhead face curious blush false", text = "She just told me she was going to read a book.")

    call process_character(sa, appearance = "outfit clothes pose handface face angry blush false", text = "Read a book?!")
    call process_character(sa, appearance = "outfit clothes pose handface face angry blush false", text = "Ugh!")
    call process_character(n, appearance = "pose handpocket face concerned blush false", text = "I guess she's different now than we remember.")
    call process_character(sa, appearance = "outfit clothes pose handsbehind face angry blush false", text = "I'll say!")
    call process_character(sa, appearance = "outfit clothes pose handsbehind face angry blush false", text = "Since when did she like reading books?")
    call process_character(n, appearance = "pose behindhead face curious blush false", text = "She dresses differently too.")
    call process_character(sa, appearance = "outfit clothes pose handface face curious blush false", text = "...")
    call process_character(sa, appearance = "outfit clothes pose handface face curious blush false", text = "Dresses different?")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "Well, I'd just go see for yourself.")
    call process_character(sa, appearance = "outfit clothes pose handface face curious blush false", text = "...")
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "Sounds like she needs some more fun introduced into her schedule!")
    call process_character(sa, appearance = "outfit clothes pose leaning face happy blush false", text = "And I'm just the one to do it!")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "...")
    call process_character(n, appearance = "pose handpocket face curious blush false", text = "(Good luck...)")

    $ reset_all_characters()
    if started_main_game:
        $ had_julia_arrived_scene = True
        call day_reset_locations_chars
        call day_start_after_location_reset
    else:
        jump debug_menu

    return

label edna_pre_arrival_scene:
    call process_scene_beginning(bg = "bg kitchen_daytime")
    $ nate_room.decide_and_play_daily_music_queue()

    $ sa.position = "right"
    $ k.position = "right"
    $ julia.position = "right"


    $ display_multiple_characters([ (si, "outfit clothes pose handsfront face neutral blush false"), (n, "outfit clothesjacket pose handpocket face aroused blush false") ])

    call process_character(n, appearance = "outfit clothesjacket pose handpocket face aroused blush false", text = "{i}Yawn.{/i}..")
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "Good morning sleepyhead!")
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face neutral blush false", text = "Morning Mom.")
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "Did you and your sister stay up late last night?")
    call process_character(n, appearance = "outfit clothesjacket pose behindhead face neutral blush false", text = "Hehe, yeah...")
    call process_character(n, appearance = "outfit clothesjacket pose behindhead face neutral blush false", text = "We were playing this new video game.")
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "You two lose all sense of time when you get locked into a new game!")

    $ replace_position = True
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "{i}Yawn.{/i}..")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "Your brother was just telling me you two had a very active night together.")

    if "sam_simone_threesome_scene" in scenes_completed:
        call process_character(si, appearance = "pose armunder face curious blush false", text = "Were you two doing more than just playing video games last night?")
        call process_character(si, appearance = "pose armunder face curious blush false", text = "I thought I heard noises from your room other than the TV...")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "...")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "Well...")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "I would say we played video games more than we fucked...")
        call process_character(sa, appearance = "pose handsbehind face neutral blush false", text = "Yeah...{w=1.0} we did do a few quickies in between gaming!")
        call process_character(sa, appearance = "pose handsbehind face happy blush false", text = "I think that's what a short fuck is called!")
    elif "sam_scene_vaginal" in scenes_completed:
        call process_character(sa, appearance = "pose handface face concerned blush false", text = "A-Active night?")
        call process_character(si, appearance = "pose armunder face happy blush false", text = "You both were absorbed in your video game!")
        call process_character(sa, appearance = "pose handsbehind face happy blush false", text = "O-Oh, yes!")
        call process_character(sa, appearance = "pose handsbehind face happy blush false", text = "That!")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "...")
        call process_character(si, appearance = "pose handsfront face neutral blush false", text = "Did you not want me to know you were staying up late again?")
        call process_character(sa, appearance = "pose handface face concerned blush false", text = "(I thought at first [n.say_name] told Mom about how we've been...)")
        call process_character(si, appearance = "pose handsup face neutral blush false", text = "I know when you two are up late.")
        call process_character(si, appearance = "pose handsup face neutral blush false", text = "I can hear you stomping down the hallway when you head for bed!")
        call process_character(sa, appearance = "pose handface face curious blush false", text = "(I hope she can't hear us when we're fucking)")
        call process_character(sa, appearance = "pose handface face curious blush false", text = "([n.say_name] and I can get pretty noisy...)")
    else:
        call process_character(sa, appearance = "pose handsbehind face neutral blush false", text = "We did for sure!")
        call process_character(sa, appearance = "pose handsbehind face happy blush false", text = "[n.say_name] and I were trying to complete this one level that was driving us crazy!")
        call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "That level was so hard!")
        call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "We had to restart tons of times!")
        call process_character(sa, appearance = "pose handface face angry blush false", text = "I didn't want to give up on it, I knew it could be beaten!")
        call process_character(n, appearance = "pose behindhead face neutral blush false", text = "When we finally finished, we both went straight to bed.")
        call process_character(sa, appearance = "pose leaning face happy blush false", text = "I almost fell asleep on the floor!")

    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "Well make sure to get some good rest tonight.")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "We have a busy day tomorrow!")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "We do?")
    call process_character(sa, appearance = "outfit clothes pose handface face embarrassed blush false", text = "Are we getting up early?")
    call process_character(sa, appearance = "outfit clothes pose handface face embarrassed blush false", text = "I'm usually not a fan of that...")
    call process_character(si, appearance = "pose handsup face happy blush false", text = "We're going to finally visit grandma!")
    call process_character(sa, appearance = "outfit clothes pose leaning face neutral blush false", text = "We are?!")
    call process_character(n, appearance = "pose twohandfist face happy blush false", text = "Grandma!")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "She's been chomping at the bit to see us.")
    call process_character(si, appearance = "pose armunder face happy blush false", text = "Especially you two!")
    call process_character(sa, appearance = "outfit clothes pose handface face happy blush false", text = "Grandma is the best!")
    call process_character(n, appearance = "pose handfist face happy blush false", text = "I hope we can make fudge while we're over!")
    call process_character(sa, appearance = "outfit clothes pose leaning face happy blush false", text = "Or lots of cookies!")
    call process_character(si, appearance = "pose handsup face happy blush false", text = "Haha, we'll see.")
    call process_character(k, appearance = "outfit clothes pose handhip face neutral blush false", text = "I heard some loud, happy voices while I was upstairs.")
    call process_character(k, appearance = "outfit clothes pose handhip face neutral blush false", text = "What's gotten [n.say_name] and [sa.say_name] so excited?")
    call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "We're gonna go see Grandma tomorrow!")
    call process_character(k, appearance = "outfit clothes pose armsup face neutral blush false", text = "Oh, we are Mom?")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "She really wants to see us this summer.")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "You're not working tomorrow are you [k.say_name]?")
    call process_character(k, appearance = "outfit clothes pose armsup face happy blush false", text = "It just so happens I have the day off tomorrow, so I'm free!")
    call process_character(si, appearance = "pose handsfront face happy blush false", text = "Perfect!")
    call process_character(si, appearance = "pose handsup face happy blush false", text = "Grandma will be delighted that we can all make it!")
    call process_character(k, appearance = "outfit clothes pose armcross face neutral blush false", text = "I'd like to see what her renovated condo looks like!")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "She seems very happy with it.")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "Grandma's well acclimated to the community there now.")
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "Can we check out the beach while we're there?")
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "I hope the waves are big!")
    call process_character(sa, appearance = "outfit clothes pose handface face happy blush false", text = "If they are, I'm totally going in!")
    call process_character(n, appearance = "pose handfist face happy blush false", text = "Me too!")
    call process_character(k, appearance = "outfit clothes pose armsup face neutral blush false", text = "Me three!")
    call process_character(k, appearance = "outfit clothes pose armsup face neutral blush false", text = "Though I should get a boogie board for wave riding.")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "It's great that we don't have to travel far when visiting Grandma now.")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "Our time will be much more flexible with her.")
    call process_character(n, appearance = "pose handpocket face neutral blush false", text = "So we'll be able to see her more?")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "Absolutely!")
    call process_character(si, appearance = "pose handsfront face neutral blush false", text = "You'll be able to see her much more often!")
    call process_character(julia, appearance = "outfit clothes pose armcross face neutral blush false", text = "Are you talking about Grandma?")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "Yes, we've all planned to go see her tomorrow!")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "Would you like to come with us?")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "My Mom is picking me up tomorrow for a doctor's appointment, so I can't go.")
    call process_character(n, appearance = "pose behindhead face concerned blush false", text = "Aw, that's too bad [julia.say_name].")
    call process_character(n, appearance = "pose behindhead face concerned blush false", text = "Are you going to go over some other time?")
    call process_character(julia, appearance = "pose handface face neutral blush false", text = "I'm sure I will since my Mom goes to see her all the time.")
    call process_character(julia, appearance = "pose handup face neutral blush false", text = "We've already seen her renovated condo.")
    call process_character(julia, appearance = "pose handup face happy blush false", text = "It looks good.")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "Alright, well I'm glad you won't be stuck home alone tomorrow.")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "I would have been concerned.")
    call process_character(k, appearance = "outfit clothes pose armcross face neutral blush false", text = "We'll need to plan a day where all of us can meet up.")
    call process_character(k, appearance = "outfit clothes pose armcross face neutral blush false", text = "Would be fun for the whole family to hang out.")
    call process_character(sa, appearance = "outfit clothes pose handface face neutral blush false", text = "I hope that will happen this summer!")
    call process_character(n, appearance = "pose twohandfist face neutral blush false", text = "Yeah!")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "It will take some coordination, but we should be able to make that happen.")
    call process_character(si, appearance = "pose handsup face happy blush false", text = "But for tomorrow we'll spend time with Grandma!")

    $ replace_position = False
    $ reset_all_characters()
    if started_main_game:
        $ had_edna_pre_arrival_scene = True
        show screen hud
        $ advance_time_return_location.start(force_music_change = True, morning_wake_lines = False)
    else:
        jump debug_menu

    return

label edna_arrival_scene:
    $ replace_position = True
    call process_scene_beginning(bg = "bg edna_house_daytime")
    $ edna_house.decide_and_play_daily_music_queue()

    python hide:
        for char in character_list():
            char.position = "right"

    $ display_multiple_characters([ (edna, "outfit clothes pose handclasp face happy blush false position left mouth red"), (n, "outfit clothesjacket pose twohandfist face happy blush false") ])
    window show
    "Woman" "You're here!"

    call process_character(n, appearance = "outfit clothesjacket pose twohandfist face happy blush false", text = "Grandma!")
    call process_character(sa, appearance = "outfit clothes pose leaning face happy blush false", text = "We're pumped to be here Grandma!")
    call change_character_name(edna, prompt = "Grandma's name")
    
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "You two are as adorable as ever!")
    call process_character(k, appearance = "outfit clothes pose handhip face neutral blush false", text = "Hey Grandma.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "[k.say_name]!")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "You look prepped to win an international sports championship!")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "Have you joined any athletic associations yet?")
    call process_character(k, appearance = "pose armsup face happy blush false", text = "Not yet, but I'm thinking about it!")
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "Hi Mom.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "Are you finally moved in at your new place [si.say_name]?")
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "Yes, I'm happy to say!")
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "There were piles of boxes we had to sort through, but we got it done!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face neutral blush false", text = "When you get old like me, you just want less and less stuff to deal with.")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "That's why condo living is so great.")
    call process_character(k, appearance = "pose armcross face neutral blush false", text = "This place looks great Grandma!")
    call process_character(k, appearance = "pose armcross face neutral blush false", text = "It definitely has that brand spanking new feel!")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "It does.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "Cost a pretty penny, but I think it was worth every cent.")
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "Have you gotten accustomed to the retired life Mom?")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "I may be retired now, but I'm staying active.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "That's why I like the community here.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face happy blush false", text = "Every day there's always something going on.")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "That's good you're staying active Grandma.")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "Yes, it's important.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "I'm not going to become a doddery old fart!")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "Haha, Mom!")
    call process_character(sa, appearance = "pose handface face neutral blush false", text = "Grandma! Grandma!")
    call process_character(sa, appearance = "pose handface face neutral blush false", text = "Are you going to make some of your fudge?")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false")
    call process_character(n, appearance = "outfit clothesjacket pose handfist face happy blush false", text = "We can help with it!")
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "[n.say_name] and [sa.say_name] always look forward to your treats Mom!")
    call process_character(edna, appearance = "outfit clothes pose handhip face concerned blush false", text = "I'm sorry you two, but I didn't get a chance to buy the chocolate to make fudge...")
    call process_character(n, appearance = "outfit clothesjacket pose behindhead face concerned blush false", text = "Aww...")
    call process_character(sa, appearance = "pose handface face concerned blush false", text = "No fudge?")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "But I did pick up some ice cream and chocolate syrup!")
    call process_character(edna, appearance = "outfit clothes pose fisthip face happy blush false", text = "So we can have milkshakes!")
    call process_character(sa, appearance = "pose handsbehind face neutral blush false", text = "{i}Gasp!{/i}")
    call process_character(n, appearance = "outfit clothesjacket pose twohandfist face happy blush false", text = "Did you say milkshakes Grandma?!")
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "Oh boy, you said the magic word Mom, haha!")
    call process_character(sa, appearance = "pose leaning face happy blush false", text = "I'm doubling up the chocolate on mine!")
    call process_character(n, appearance = "outfit clothesjacket pose handfist face happy blush false", text = "I like mine super thick with extra ice cream!")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "You two are going to be flying all night with that amount of chocolate in you!")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "They'll burn it all off.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "Especially if they go down to the beach.")
    call process_character(sa, appearance = "pose handface face neutral blush false", text = "Can we go there soon?")
    call process_character(sa, appearance = "pose handface face neutral blush false", text = "I want to go swimming!")

    if "simone_scene_swimsuit" in scenes_completed and "sam_scene_swimsuit" not in scenes_completed:
        call process_character(si, appearance = "pose armunder face curious blush false", text = "But you need a new bathing suit, don't you [sa.say_name]?")
        call process_character(sa, appearance = "blush false", text = "Shoot, that's right...")
        call process_character(n, appearance = "pose behindhead face neutral blush false", text = "Did you bring my swimsuit Mom?")
        call process_character(si, appearance = "pose armunder face happy blush false", text = "You know, I had both yours and mine right at the door, and I forgot to grab them as we left!")
        call process_character(si, appearance = "pose handsup face neutral blush false", text = "We'll buy [sa.say_name] a new swimsuit and I'll be sure to bring all of them next time!")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "We can still walk down there though.")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "Just leave your shoes and socks here, and roll up your pants!")
    elif "simone_scene_swimsuit" not in scenes_completed and "sam_scene_swimsuit" in scenes_completed:
        call process_character(si, appearance = "pose armunder face curious blush false", text = "Did you remember to bring your suit?")
        call process_character(sa, appearance = "pose handface face concerned blush false", text = "Ooh...")
        call process_character(sa, appearance = "pose handface face concerned blush false", text = "I thought you were grabbing it Mom.")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "I thought the same thing too...")
        call process_character(si, appearance = "pose handsfront face neutral blush false", text = "I did say to bring your suits, but you may not have heard me from downstairs.")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "We can still walk down there though.")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "Just leave your shoes and socks here, and roll up your pants!")
    else:
        call process_character(si, appearance = "pose armunder face curious blush false", text = "But you need a new bathing suit, don't you [sa.say_name]?")
        call process_character(sa, appearance = "pose handsbehind face concerned blush false", text = "Shoot, that's right...")
        call process_character(si, appearance = "pose armunder face curious blush false", text = "[n.say_name], did you remember to bring your suit?")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "Oh...")
        call process_character(n, appearance = "pose behindhead face curious blush false", text = "I thought you had grabbed it Mom.")
        call process_character(si, appearance = "pose handsfront face neutral blush false", text = "I did say to bring your suit, but you may not have heard me from downstairs.")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "We can still walk down there though.")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "Just leave your shoes and socks here, and roll up your pants!")


    call process_character(k, appearance = "pose armsup face happy blush false", text = "I came prepared with my suit!")
    call process_character(si, appearance = "pose handsup face happy blush false", text = "That's no surprise!")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "[k.say_name] loves our pool area in the backyard.")
    call process_character(si, appearance = "pose handsup face neutral blush false", text = "She sunbathes out there all the time.")
    call process_character(edna, appearance = "pose fisthip face happy blush false", text = "That explains why you're so tan [k.say_name]!")
    call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "I myself would like to get out in the sun more.")
    call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "But I have to protect my scalp with a hat.")
    call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "My hair doesn't protect me from the sun as well anymore.")
    call process_character(k, appearance = "pose handhip face neutral blush false", text = "Your hair still looks very nice Grandma.")
    call process_character(edna, appearance = "pose handhip face happy blush false", text = "Thank you [k.say_name].")
    call process_character(edna, appearance = "pose handhip face happy blush false", text = "I wish it was a little less gray!")
    call process_character(edna, appearance = "pose handhip face happy blush false", text = "At least I can still style it.")
    call process_character(sa, appearance = "pose leaning face neutral blush false", text = "Is the ocean water warm Grandma?")
    call process_character(sa, appearance = "pose leaning face neutral blush false", text = "And have the waves been big?")
    call process_character(edna, appearance = "pose fisthip face happy blush false", text = "I haven't checked today, so why don't we see for ourselves?")
    call process_character(edna, appearance = "pose fisthip face happy blush false", text = "Let's head down there.")
    call process_character(k, appearance = "pose armcross face happy blush false", text = "Sounds good to me!")
    call process_character(n, appearance = "pose handfist face happy blush false", text = "Yeah, I'm ready to go!")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "I might get a bit hot down there.")
    call process_character(si, appearance = "pose armunder face neutral blush false", text = "I'll need to stay in the shade.")
    call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "Get some bottled water out of the fridge so you can stay hydrated.")
    call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "Oh! Before I forget...")
    call process_character(n, appearance = "pose behindhead face neutral blush false", text = "What's up Grandma?")
    call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "You'll each need a pass card if you're going to be visiting more often.")
    call process_character(edna, appearance = "pose handhip face neutral blush false", text = "Otherwise I'll have to call the condo office and sign you in as guests every time you want to visit.")
    call process_character(edna, appearance = "pose handhip face happy blush false", text = "This will make it easy for any of you to come and go as you please!")
    call process_character(sa, appearance = "pose handface face concerned blush false", text = "Will it take a long time?")
    call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "It's very quick [sa.say_name]!")
    call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "The beach will only be seconds away once it's done.")

    call process_new_location("bg beach_daytime")

    python hide:
        for char in character_list():
            char.position = "right"
            char.outfit = "clothes"


    pause 0.25
    $ display_multiple_characters([ (edna, "outfit clothes pose handhip face neutral blush false position left hat sunhat mouth red"), (k, "outfit bikini pose armsup face happy blush false") ])
    pause 0.25

    call process_character(k, appearance = "outfit bikini pose armsup face happy blush false", text = "Ooh man!")
    call process_character(k, appearance = "outfit bikini pose armsup face happy blush false", text = "It's just awesome how you're right next to the beach Grandma!")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "I walk down here every morning and take a long stroll.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "Smelling the ocean breeze is a great way to start off the day.")
    call process_character(k, appearance = "outfit bikini pose handhip face happy blush false", text = "I'll bet!")
    call process_character(k, appearance = "outfit bikini pose handhip face happy blush false", text = "That's it, I'm sold!")
    call process_character(k, appearance = "outfit bikini pose handhip face happy blush false", text = "I'm going to save up and buy my own place here!")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "That might be a little difficult [k.say_name]!")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "You have to be fifty five or older to own here!")
    call process_character(k, appearance = "outfit bikini pose armcross face embarrassed blush false", text = "Damn, really?!")
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "I can understand the restriction.")
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "A lot of older people want to have a place that is peaceful and quiet.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "And they don't want kids running amok.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "Late night parties and loud music are a no-no around here.")
    call process_character(k, appearance = "outfit bikini pose handhip face concerned blush false", text = "Yeah...{w=1.0}that makes sense.")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "But I know my grandkids are well behaved!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "If any of you want to stay over a few nights by all means!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "I've got a spare bedroom and a pull out couch, if needed.")
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "You hear that [sa.say_name], [n.say_name], and [k.say_name]?")
    call process_character(n, appearance = "outfit clothes pose handfist face happy blush false", text = "So we could stay over if we wanted?")
    call process_character(sa, appearance = "pose handface face neutral blush false", text = "That would be cool!")
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "What do you say to Grandma?")
    call process_character(n, appearance = "outfit clothes pose twohandfist face happy blush false", text = "Thank you Grandma!")
    call process_character(sa, appearance = "pose leaning face happy blush false", text = "Thank you so much!")
    call process_character(k, appearance = "outfit bikini pose armsup face neutral blush false", text = "Yeah, thanks Grandma.")
    call process_character(k, appearance = "outfit bikini pose armsup face happy blush false", text = "I'll be sure to take advantage of the offer!")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "You're welcome!")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "So, how's the water?")
    call process_character(sa, appearance = "pose handsbehind face neutral blush false", text = "I could only put my legs in, but it feels nice!")

    if "janet_scene_minigame_intro" in scenes_completed or "janet_scene_naked" in scenes_completed:
        call process_character(n, appearance = "pose handsdown face neutral blush false", text = "I've swam here before with Aunt [janet.say_name], and the water is really warm!")
        call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "Yes, this is [janet.say_name]'s favorite beach area.")
        call process_character(edna, appearance = "pose fisthip face neutral blush false", text = "I see her swimming back and forth in the ocean on occasion.")
        call process_character(edna, appearance = "pose fisthip face curious blush false", text = "I think I might have spotted you too [n.say_name].")
        call process_character(n, appearance = "pose handfist face happy blush false", text = "Aunt [janet.say_name] and I race each other in the ocean sometimes, so it probably was me!")
        call process_character(edna, appearance = "pose handhip face happy blush false", text = "Ah, it was you I saw then!")
    else:
        call process_character(n, appearance = "pose behindhead face neutral blush false", text = "I wish I brought my suit so I could go in.")
        call process_character(n, appearance = "pose behindhead face happy blush false", text = "The water seems really warm!")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "The sun has heated up the water a lot this summer.")
        call process_character(edna, appearance = "pose handclasp face neutral blush false", text = "As long as there isn't much rain, the temperature should remain up there for a while.")

    call process_character(sa, appearance = "pose handface face happy blush false", text = "I hope the waves will be big the next time we're here!")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "Oh I'm sure they will be.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "The wind has flattened the waves today..")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "But I heard it will shift in the coming days.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "Then you should see some big ones coming in.")
    call process_character(sa, appearance = "pose leaning face happy blush false", text = "Can't wait!")
    call process_character(k, appearance = "outfit bikini pose armsup face neutral blush false", text = "Hey, are there any volleyball nets we can setup?")
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "Oh boy, here we go...")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "I think there is actually, yes!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "Ask over at the lifeguard shack.")
    call process_character(k, appearance = "outfit bikini pose handhip face happy blush false", text = "Anyone up for a match?")
    call process_character(k, appearance = "outfit bikini pose handhip face happy blush false", text = "How about me and [sa.say_name] versus [n.say_name] and Mom?")
    call process_character(n, appearance = "outfit clothes pose behindhead face curious blush false", text = "...")
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "I think I'll pass on the offer!")
    call process_character(si, appearance = "outfit clothes pose armunder face neutral blush false", text = "I don't have the proper attire.")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "And even if I did, I'm not very good at volleyball!")
    call process_character(k, appearance = "outfit bikini pose armcross face neutral blush false", text = "How about you Grandma?")
    call process_character(edna, appearance = "outfit clothes pose handhip face embarrassed blush false", text = "That's a bit too intense of a sport for me!")
    call process_character(k, appearance = "outfit bikini pose handhip face neutral blush false", text = "Alright, then in that case...")
    call process_character(k, appearance = "outfit bikini pose handhip face happy blush false", text = "I'll have to settle for a handicap match!")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false")
    call process_character(n, appearance = "outfit clothes pose handsdown face curious blush false", text = "Handicap match?")
    call process_character(k, appearance = "outfit bikini pose armsup face happy blush false", text = "You and [sa.say_name] take me on!")
    call process_character(sa, appearance = "pose leaning face neutral blush false", text = "That sounds fun [n.say_name]!")
    call process_character(sa, appearance = "pose leaning face happy blush false", text = "We can beat [k.say_name] together!")
    call process_character(k, appearance = "outfit bikini pose armcross face happy blush false", text = "I'd like to see you two try!")
    call process_character(n, appearance = "outfit clothes pose behindhead face curious blush false", text = "...")
    call process_character(si, appearance = "outfit clothes pose handsup face curious blush false", text = "[k.say_name], try not to do your hard spikes, okay?")
    call process_character(si, appearance = "outfit clothes pose handsup face curious blush false", text = "That will hurt if [n.say_name] or [sa.say_name] gets hit in the face.")
    call process_character(k, appearance = "outfit bikini pose armsup face happy blush false", text = "Aah, that just builds fortitude!")
    call process_character(si, appearance = "outfit clothes pose handsup face concerned blush false", text = "[k.say_name]...")
    call process_character(n, appearance = "outfit clothes pose handsdown face concerned blush false", text = "{i}Gulp.{/i}..")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "I want to get some video of this!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "[n.say_name], do you have one of those super phones?")
    call process_character(n, appearance = "outfit clothes pose behindhead face curious blush false", text = "...")
    call process_character(n, appearance = "outfit clothes pose behindhead face curious blush false", text = "You mean a smartphone Grandma?")
    call process_character(edna, appearance = "outfit clothes pose fisthip face happy blush false", text = "Yes! That's it.")
    call process_character(edna, appearance = "outfit clothes pose fisthip face happy blush false", text = "Can you show me how to take video with it?")
    call process_character(edna, appearance = "outfit clothes pose fisthip face neutral blush false", text = "I hate how complicated this new technology is!")
    call process_character(n, appearance = "outfit clothes pose handsdown face neutral blush false", text = "Sure.")
    call process_character(n, appearance = "outfit clothes pose handsdown face neutral blush false", text = "{cps=40}First thing you do is go to this app here, and then you-{/cps}{w=0.75}{nw}")
    call process_character(edna, appearance = "outfit clothes pose handclasp face shock blush false", text = "You went too fast there!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face shock blush false", text = "What was the button you pressed again?")
    call process_character(n, appearance = "outfit clothes pose handsdown face curious blush false", text = "...")

    call process_new_location("bg edna_house_daytime")

    python hide:
        for char in character_list():
            char.position = "right"
            char.outfit = "clothes"


    pause 0.25
    $ display_multiple_characters([ (edna, "outfit clothes pose handclasp face neutral blush false position left mouth red"), (si, "outfit clothes pose handsup face neutral blush false") ])
    pause 0.25

    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "You all had a great time at the beach, didn't you?")
    call process_character(sa, appearance = "pose leaning face happy blush false", text = "I sure did!")
    call process_character(k, appearance = "outfit clothes pose armsup face happy blush false", text = "I could stay there all day!")
    call process_character(n, appearance = "outfit clothesjacket pose handfist face happy blush false", text = "I definitely want to come back again!")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "We're all attracted to the beach it seems.")
    call process_character(edna, appearance = "outfit clothes pose handhip face happy blush false", text = "I guess it runs in our family!")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "What a volleyball match [k.say_name], [sa.say_name], and [n.say_name] had!")
    call process_character(si, appearance = "outfit clothes pose armunder face happy blush false", text = "I was getting dizzy watching!")
    call process_character(edna, appearance = "outfit clothes pose fisthip face happy blush false", text = "You all were holding your own.")
    call process_character(k, appearance = "outfit clothes pose handhip face happy blush false", text = "I enjoyed the challenge!")
    call process_character(sa, appearance = "pose leaning face neutral blush false", text = "You made some epic dives to save the ball [k.say_name]!")
    call process_character(sa, appearance = "pose leaning face happy blush false", text = "But [n.say_name] and I still scored a few points on you!")
    call process_character(k, appearance = "outfit clothes pose armcross face neutral blush false", text = "You caught me off guard a few times, I'll admit.")
    call process_character(k, appearance = "outfit clothes pose armcross face happy blush false", text = "But I wasn't going to let you win outright!")
    call process_character(n, appearance = "outfit clothesjacket pose behindhead face curious blush false", text = "Yeah...{w=1.0}I could tell you wanted to win when you spiked the ball towards the end.")
    call process_character(k, appearance = "outfit clothes pose armsup face neutral blush false", text = "I made sure to spike it away from you [n.say_name].")
    call process_character(k, appearance = "outfit clothes pose armsup face happy blush false", text = "You still ran when I did it though, haha!")
    call process_character(n, appearance = "outfit clothesjacket pose handpocket face curious blush false", text = "...")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "Were you planning to stay for dinner?")
    call process_character(edna, appearance = "outfit clothes pose handhip face neutral blush false", text = "The condominium houses a great local restaurant.")
    call process_character(si, appearance = "outfit clothes pose handsup face neutral blush false", text = "Thanks for the offer Mom, but we have to be heading back.")
    call process_character(sa, appearance = "pose handface face concerned blush false", text = "Already?")
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "Remember what Grandma said before?")
    call process_character(si, appearance = "outfit clothes pose handsfront face neutral blush false", text = "You can come over here any time you want.")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "There's no shortage of things to do when you're with Grandma!")
    call process_character(edna, appearance = "outfit clothes pose handclasp face happy blush false", text = "Next time I'll be sure to whip up some fudge for you to take home.")
    call process_character(n, appearance = "outfit clothesjacket pose handfist face happy blush false", text = "Yess!")
    call process_character(k, appearance = "outfit clothes pose handhip face neutral blush false", text = "Bye Grandma!")
    call process_character(k, appearance = "outfit clothes pose handhip face neutral blush false", text = "It's cool to hear you're doing well!")
    call process_character(n, appearance = "outfit clothesjacket pose twohandfist face neutral blush false", text = "We had a great time Grandma!")
    call process_character(sa, appearance = "pose handsbehind face happy blush false", text = "The milkshakes were super tasty!")
    call process_character(si, appearance = "outfit clothes pose handsup face happy blush false", text = "Thanks Mom, I'll talk to you later!")

    $ replace_position = False
    $ reset_all_characters()
    if started_main_game:
        $ had_edna_intro_scene = True
        call day_reset_locations_chars
        call day_start_after_location_reset
    else:
        jump debug_menu

    return