init 100 python:
    # please see jamnut example mod for more information/examples
    def example_extra_new_zone_location_add_option(func):
        def func_extension():
            options = func()
            # we can name our option to enable the mod here
            # if you want to check whether player enabled your mod
            # use persistent.enable_example_extra_scene
            # replacing example_extra_scene with name of mod ofc
            options.append( ("Enable Example New Zone/Location", "example_extra_new_zone_location"))
            return options
        return func_extension

    mod_options = example_extra_new_zone_location_add_option(mod_options)

    def example_extra_new_zone_location_add_location(func):
        def func_extension():
            locations = func()
            # we can name our option to enable the mod here
            # if you want to check whether player enabled your mod
            # use persistent.enable_example_extra_scene
            # replacing example_extra_scene with name of mod ofc
            if persistent.example_extra_new_zone_location:
                locations.append( example_new_location )
            return locations
        return func_extension

    location_list = example_extra_new_zone_location_add_location(location_list)

    def example_extra_new_zone_location_add_zone(func):
        def func_extension():
            zones = func()
            if persistent.example_extra_new_zone_location:
                zones.append( example_new_zone )
            return zones
        return func_extension

    zone_list = example_extra_new_zone_location_add_zone(zone_list)

    # we can add save variables here
    def example_extra_new_zone_location_add_save_variable(func):
        def func_extension():
            varis = func()
            varis.append( Save_Variable( "example_new_zone" , "Example_New_Zone()" ) )
            varis.append( Save_Variable( "example_new_location" , "Example_New_Location()" ) )
            return varis
        return func_extension

    initialization_variables = example_extra_new_zone_location_add_save_variable(initialization_variables)

    class Example_New_Zone(Zone):
        def enabled_focused_text(self):
            return "Example Mall"

        def base_locations(self):
            place_list = []
            place_list.append(store.example_new_location)

            return place_list

        def button_image_filename_full_path(self):
            return "images/mods/example_new_zone_location/navigation_example_new_zone.png"

        def is_enabled(self):
            # whether zone is enabled
            return True
            
        def unavailable_focused_text(self):
            # text when it's unavailable
            return "Unavailable"


    class Example_New_Location(Location):
        def __init__(self):
            Location.__init__(self)

        def zone(self):
            # what zone this location belongs to
            return store.example_new_zone

        def name(self):
            return "Example Mall Store"

        def internal_name(self):
            return "example_new_location"

        def unavailable_focused_text(self):
            # text when it's unavailable
            return "Unavailable"

        def button_image_filename_full_path(self):
            return "images/mods/example_new_zone_location/navigation_example_new_location.png"

        def day_music_list(self):
            return outside_daytime_music_list()

        def night_music_list(self):
            return outside_evening_music_list()
